package com.xforceplus.tenant.security.starter.webflux.adapter;

import com.xforceplus.tenant.security.token.domain.UserType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

import java.util.List;
import java.util.stream.Collectors;


/**
 * @author geewit
 */
public class RequestTokenUtils {
    private static final Logger logger = LoggerFactory.getLogger(RequestTokenUtils.class);
    public static String getToken(ServerHttpRequest request) {

        List<String> tokens = request.getHeaders().get(UserType.USER.tokenKey());
        String token = getTokenFromList(tokens);
        if(token == null) {
            logger.warn("Header中无token");
            tokens = request.getQueryParams().get(UserType.USER.tokenKey());
            token = getTokenFromList(tokens);
        }
        if(token == null) {
            logger.warn("Param中无token");
            List<HttpCookie> cookies = request.getCookies().get(UserType.USER.tokenKey());
            if(cookies != null && !cookies.isEmpty()) {
                tokens = cookies.stream().map(HttpCookie::getValue).collect(Collectors.toList());
                token = getTokenFromList(tokens);
            }
        }
        if(token == null) {
            logger.warn("Cookie中无token");
        }
        logger.warn("token = {}", token);
        return token;
    }

    private static String getTokenFromList(List<String> tokens) {
        if (tokens == null || tokens.isEmpty()) {
            return null;
        }
        String token = tokens.stream().filter(StringUtils::isNotBlank).findFirst().orElse(null);
        return token;
    }
}
