/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.token.decoder;

import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtDecoder {
    private static final Logger log = LoggerFactory.getLogger(JwtDecoder.class);

    public static Map<String, String> decode(String token, String secret, Map<Long, String> tenantSecrets) {
        Map claims;
        block10: {
            claims = null;
            if (StringUtils.isNotBlank((CharSequence)token)) {
                try {
                    String tenantIdVal;
                    claims = JwtUtils.decodeToken((String)token);
                    if (claims == null || claims.isEmpty()) break block10;
                    if (tenantSecrets != null && !tenantSecrets.isEmpty() && !JwtUtils.isBlank((CharSequence)(tenantIdVal = (String)claims.get("tenant_secret_id")))) {
                        try {
                            long tenantId = Long.parseLong(tenantIdVal);
                            if (tenantId > 0L) {
                                secret = tenantSecrets.getOrDefault(tenantId, secret);
                            }
                        }
                        catch (NumberFormatException tenantId) {
                            // empty catch block
                        }
                    }
                    JwtUtils.verifyTokenBySerect((String)token, (String)secret);
                }
                catch (TokenExpiredException e) {
                    log.warn("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
                    String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                    log.warn(message);
                    return null;
                }
                catch (JWTVerificationException e) {
                    log.warn("token\u6821\u9a8c\u5931\u8d25JWTVerificationException,token=={}", (Object)token);
                    String message = "token\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                    log.warn(message);
                    return null;
                }
                catch (Exception e) {
                    String message = "token\u89e3\u6790\u5931\u8d25";
                    log.warn("{}, secret = {}, token={}", new Object[]{message, secret, token});
                    return null;
                }
            }
        }
        if (claims == null) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            log.warn("claims == null, {}", (Object)message);
            return null;
        }
        return claims;
    }

    @Deprecated
    public static Map<String, String> decode(String token, String secret) {
        return JwtDecoder.decode(token, secret, Collections.emptyMap());
    }

    public static String parseUserInfoFromClaims(Map<String, String> claims) {
        if (claims == null) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            log.warn("claims == null, {}", (Object)message);
            return null;
        }
        String systemType = claims.get("type");
        if (!UserType.USER.value().equals(systemType)) {
            String message = "token\u975e\u6cd5\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            log.warn("claims == null, {}", (Object)message);
            return null;
        }
        String encodedUserInfo = claims.get("userinfo");
        if (StringUtils.isBlank((CharSequence)encodedUserInfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            log.warn("userinfo isBlank, {}", (Object)message);
            return null;
        }
        return encodedUserInfo;
    }

    public static String parseUserInfoFromToken(String token, String secret) {
        Map<String, String> claims = JwtDecoder.decode(token, secret);
        return JwtDecoder.parseUserInfoFromClaims(claims);
    }
}

