package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;


/**
 * 用户角色
 * @author geewit
 */
public interface IRole {
    /**
     * 用户角色id
     * @return 用户角色id
     */
    @JsonView({View.class, TokenView.class})
    Long getId();

    /**
     * 用户角色类型
     * @return 用户角色类型
     */
    @JsonView({View.class, TokenView.class})
    Integer getType();

    /**
     * 租户id
     * @return 租户id
     */
    @JsonView({View.class, TokenView.class})
    Long getTenantId();

    /**
     * 用户角色代码
     * @return 用户角色代码
     */
    @JsonView({View.class, TokenView.class})
    String getCode();

    /**
     * 用户角色名称
     * @return 用户角色名称
     */
    @JsonView({View.class, TokenView.class})
    String getName();
}
