package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Set;

/**
 * 用户token对象
 * @author geewit
 */
public interface ITokenUser<R extends IRole> extends Serializable {
    /**
     * 用户ID
     * @return 用户ID
     */
    @JsonView({View.class, TokenView.class})
    Long getId();

    /**
     * 租户ID
     * @return 租户ID
     */
    @JsonView({View.class, TokenView.class})
    Long getTenantId();

    /**
     * 登录账号id
     * @return 登录账号id
     */
    @JsonView({View.class, TokenView.class})
    Long getAccountId();

    /**
     * 用户code
     * @return 用户code
     */
    @JsonView({View.class, TokenView.class})
    String getUserCode();

    /**
     * 租户id集合
     * @return 租户id集合
     */
    @JsonView({View.class, TokenView.class})
    Set<Long> getTenantIds();

    /**
     * 租户编码
     * @return 租户编码
     */
    @JsonView({View.class, TokenView.class})
    String getTenantCode();

    /**
     * 租户名称
     * @return 租户名称
     */
    @JsonView({View.class, TokenView.class})
    String getTenantName();

    /**
     * 登录用户名
     * @return 登录用户名
     */
    @JsonView({View.class, TokenView.class})
    String getUsername();

    /**
     * 手机
     * @return 手机
     */
    @JsonView({View.class, TokenView.class})
    String getMobile();

    /**
     * 邮箱
     * @return 邮箱
     */
    @JsonView({View.class, TokenView.class})
    String getEmail();

    /**
     * 用户名称
     * @return 用户名称
     */
    @JsonView({View.class, TokenView.class})
    String getUserName();

    /**
     * jwt token
     * @return jwt token
     */
    @JsonIgnore
    String token();

    /**
     * 用户角色集合
     * @return 用户角色集合
     */
    @JsonView({View.class, TokenView.class})
    Set<R> getRoles();

    /**
     * 登录id
     * @return 登录id
     */
    @JsonView({TokenView.class})
    String getLoginId();

    /**
     * 过滤组织code集合
     * @return 过滤组织code集合
     */
    @JsonView({View.class, TokenView.class})
    String getModules();

    /**
     * 用户资源码集合
     * @return 用户资源码集合
     */
    @JsonView({View.class, TokenView.MockView.class})
    Set<String> getResourceCodes();

    /**
     * 登录帐号
     * @return 登录帐号
     */
    @JsonView({View.class, TokenView.class})
    String getLoginName();

    /**
     * 是否是模拟账号
     * @return 是否是模拟账号
     */
    default boolean isMock() {
        return StringUtils.isNotBlank(this.getLoginId()) && this.getLoginId().trim().startsWith("mock_");
    }

    /**
     * 用户绑定的clientId
     * @return 用户绑定的clientId
     */
    @JsonView({View.class, TokenView.class})
    String getClientId();
}
