package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.util.Objects;

/**
 * @author geewit
 */
@Schema(name = "会序列化为token的角色对象")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@FieldNameConstants
@Setter
public class TokenRole implements IRole {
    /**
     * 用户角色id
     */
    @JsonView({View.class, TokenView.class})
    protected Long id;

    /**
     * 用户角色类型, 0:全局角色, 1:分级角色, 2:组织角色
     */
    @JsonView({View.class, TokenView.class})
    protected Integer type;

    /**
     * 租户id
     */
    @JsonView({View.class, TokenView.class})
    protected Long tenantId;

    /**
     * 用户角色代码
     */
    @JsonView({View.class, TokenView.class})
    protected String code;

    /**
     * 用户角色名称
     */
    @JsonView({View.class, TokenView.class})
    protected String name;

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getId() {
        return id;
    }

    @Override
    public Integer getType() {
        return type;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenRole that = (TokenRole) o;
        return this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ",type=" + type +
                ", tenantId=" + tenantId +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
