package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

import java.util.Set;

/**
 * @author geewit
 */
@Schema(name = "会序列化为token的用户对象")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@FieldNameConstants
@Setter
@Getter
public class TokenUser<R extends TokenRole> implements ITokenUser<R> {
    /**
     * 用户ID
     */
    @JsonView({View.class, TokenView.class})
    protected Long id;

    /**
     * 登录id
     */
    @JsonView({TokenView.class})
    protected String loginId;

    /**
     * 当前租户ID
     */
    @JsonView({View.class, TokenView.class})
    protected Long tenantId;

    /**
     * 当前租户Code
     */
    @JsonView({View.class, TokenView.class})
    protected String tenantCode;

    /**
     * 租户名称
     */
    @JsonView({View.class, TokenView.class})
    protected String tenantName;

    /**
     * 登录账号id
     */
    @JsonView({View.class, TokenView.class})
    protected Long accountId;

    /**
     * 登录用户名
     */
    @JsonView({View.class, TokenView.class})
    protected String username;

    /**
     * 手机
     */
    @JsonView({View.class, TokenView.class})
    protected String mobile;

    /**
     * 邮箱
     */
    @JsonView({View.class, TokenView.class})
    protected String email;

    /**
     * 用户名称
     */
    @JsonView({View.class, TokenView.class})
    protected String userName;

    /**
     * 用户code
     */
    @JsonView({View.class, TokenView.class})
    protected String userCode;

    /**
     * 租户id集合
     */
    @JsonView({TokenView.class})
    protected Set<Long> tenantIds;

    /**
     * 用户角色id集合
     */
    @ArraySchema(schema = @Schema(implementation = TokenRole.class))
    @JsonView({View.class, TokenView.class})
    protected Set<R> roles;

    /**
     * 资源码集合
     */
    @JsonView({View.class, TokenView.MockView.class})
    protected Set<String> resourceCodes;

    /**
     * 过滤组织code集合
     */
    @JsonView({View.class, TokenView.class})
    protected String modules;

    /**
     * 登录帐号
     */
    @JsonView({View.class, TokenView.class})
    protected String loginName;

    /**
     * 用户绑定的clientId
     */
    @JsonView({View.class, TokenView.class})
    protected String clientId;

    /**
     * jwt token
     */
    @JsonIgnore
    protected String token;

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getId() {
        return id;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getAccountId() {
        return accountId;
    }

    @Override
    public String getUserName() {
        return userName;
    }

    @Override
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonIgnore
    @Override
    public String token() {
        return token;
    }
}
