package com.xforceplus.tenant.security.token.jackson.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.*;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;

/**
 * @author geewit
 */
public class TokenUserSerializer<U extends TokenUser<R>, R extends TokenRole> extends JsonSerializer<U> {

    private final ObjectMapper objectMapper;

    public TokenUserSerializer(ObjectMapper objectMapper) {
        if (objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        } else {
            this.objectMapper = objectMapper;
        }
        this.objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.objectMapper.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.disable(MapperFeature.DEFAULT_VIEW_INCLUSION);
    }

    public TokenUserSerializer() {
        this(new ObjectMapper());
    }

    @Override
    public void serialize(U value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        if (value.getId() != null) {
            generator.writeFieldName(TokenUser.Fields.id);
            generator.writeString(value.getId().toString());
        }
        if (value.getLoginId() != null) {
            generator.writeFieldName(TokenUser.Fields.loginId);
            generator.writeString(value.getLoginId());
        }
        if (value.getTenantId() != null) {
            generator.writeFieldName(TokenUser.Fields.tenantId);
            generator.writeString(value.getTenantId().toString());
        }
        if (value.getTenantCode() != null) {
            generator.writeFieldName(TokenUser.Fields.tenantCode);
            generator.writeString(value.getTenantCode());
        }
        if (value.getTenantName() != null) {
            generator.writeFieldName(TokenUser.Fields.tenantName);
            generator.writeString(value.getTenantName());
        }
        if (value.getAccountId() != null) {
            generator.writeFieldName(TokenUser.Fields.accountId);
            generator.writeString(value.getAccountId().toString());
        }
        if (value.getUsername() != null) {
            generator.writeFieldName(TokenUser.Fields.username);
            generator.writeString(value.getUsername());
        }
        if (value.getEmail() != null) {
            generator.writeFieldName(TokenUser.Fields.email);
            generator.writeString(value.getEmail());
        }
        if (value.getMobile() != null) {
            generator.writeFieldName(TokenUser.Fields.mobile);
            generator.writeString(value.getMobile());
        }
        if (value.getUserCode() != null) {
            generator.writeFieldName(TokenUser.Fields.userCode);
            generator.writeString(value.getUserCode());
        }
        if (value.getUserName() != null) {
            generator.writeFieldName(TokenUser.Fields.userName);
            generator.writeString(value.getUserName());
        }
        if (value.getModules() != null) {
            generator.writeFieldName(TokenUser.Fields.modules);
            generator.writeString(value.getModules());
        }
        if (value.getLoginName() != null){
            generator.writeFieldName(TokenUser.Fields.loginName);
            generator.writeString(value.getLoginName());
        }
        if (value.getRoles() != null) {
            generator.writeFieldName(TokenUser.Fields.roles);
            generator.writeRawValue(objectMapper.writerWithView(provider.getActiveView()).writeValueAsString(value.getRoles()));
        }
        if (StringUtils.isNotBlank(value.getClientId())) {
            generator.writeFieldName(TokenUser.Fields.clientId);
            generator.writeString(value.getClientId());
        }
        generator.writeEndObject();

    }
}
