package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Set;

/**
 * @author geewit
 */
public interface ITokenUser<R extends IRole> extends Serializable {
    /**
     * 用户ID
     * @return 用户ID
     */
    @ApiModelProperty("用户ID")
    Long getId();

    /**
     * 租户ID
     * @return 租户ID
     */
    @ApiModelProperty("租户ID")
    Long getTenantId();

    /**
     * 登录账号id
     * @return 登录账号id
     */
    @ApiModelProperty("登录账号id")
    Long getAccountId();

    /**
     * 用户code
     * @return 用户code
     */
    @ApiModelProperty("用户code")
    String getUserCode();

    /**
     * 租户id集合
     * @return 租户id集合
     */
    @ApiModelProperty("租户id集合")
    Set<Long> getTenantIds();

    /**
     * 租户编码
     * @return 租户编码
     */
    @ApiModelProperty("租户编码")
    String getTenantCode();

    /**
     * 租户名称
     * @return 租户名称
     */
    @ApiModelProperty("租户名称")
    String getTenantName();

    /**
     * 租户名称
     * @return 租户名称
     */
    @ApiModelProperty("登录用户名")
    String getUsername();

    /**
     * 手机
     * @return 手机
     */
    @ApiModelProperty("手机")
    String getMobile();

    /**
     * 邮箱
     * @return 邮箱
     */
    @ApiModelProperty("邮箱")
    String getEmail();

    /**
     * 邮箱
     * @return 邮箱
     */
    @ApiModelProperty("用户名称")
    String getUserName();

    /**
     * jwt token
     * @return jwt token
     */
    @JsonIgnore
    @ApiModelProperty("jwt token")
    String token();

    /**
     * 用户角色集合
     * @return 用户角色集合
     */
    @ApiModelProperty("用户角色集合")
    Set<R> getRoles();

    /**
     * 登录id
     * @return 登录id
     */
    @ApiModelProperty("登录id")
    String getLoginId();

    /**
     * 用户资源码集合
     * @return 用户资源码集合
     */
    @ApiModelProperty("用户资源码集合")
    Set<String> getResourceCodes();

    @JsonIgnore
    default String getOperaterName() {
        if(StringUtils.isNotBlank(this.getUsername())) {
            return this.getUsername();
        }
        if(StringUtils.isNotBlank(this.getMobile())) {
            return this.getMobile();
        }
        if(StringUtils.isNotBlank(this.getEmail())) {
            return this.getEmail();
        }
        return StringUtils.EMPTY;
    }

    /**
     * 是否是超级管理员
     * @return 是否是超级管理员
     */
    @ApiModelProperty("是否是超级管理员")
    default boolean isAdmin() {
        if (this.getRoles() == null || this.getRoles().isEmpty()) {
            return false;
        }
        return this.getRoles().stream().anyMatch(role -> role.getId() != null && role.getId() == 1);
    }

    /**
     * 是否是模拟账号
     * @return 是否是模拟账号
     */
    @ApiModelProperty("是否是模拟账号")
    default boolean isMock() {
        return StringUtils.isNotBlank(this.getLoginId()) && this.getLoginId().trim().startsWith("mock_");
    }
}
