package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TokenUser<R extends TokenRole> implements ITokenUser<R> {
    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户ID")
    protected Long id;

    @JsonView({TokenView.class})
    @ApiModelProperty("登录id")
    protected String loginId;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("当前租户ID")
    protected Long tenantId;

    @JsonView({View.class, TokenView.class})
    protected String tenantCode;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("租户名称")
    protected String tenantName;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("登录账号id")
    protected Long accountId;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("登录用户名")
    protected String username;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("手机")
    protected String mobile;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("邮箱")
    protected String email;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户名称")
    protected String userName;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户code")
    protected String userCode;

    @JsonView({TokenView.class})
    @ApiModelProperty("租户id集合")
    protected Set<Long> tenantIds;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户角色id集合")
    protected Set<R> roles;

    @JsonView({View.class, TokenView.MockView.class})
    @ApiModelProperty("资源码集合")
    protected Set<String> resourceCodes;

    @Override
    public Set<Long> getTenantIds() {
        return tenantIds;
    }

    public void setTenantIds(Set<Long> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @JsonIgnore
    @ApiModelProperty("jwt token")
    protected String token;

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getLoginId() {
        return loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @Override
    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    @Override
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Override
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @Override
    public Set<R> getRoles() {
        return roles;
    }

    public void setRoles(Set<R> roles) {
        this.roles = roles;
    }

    @Override
    public Set<String> getResourceCodes() {
        return resourceCodes;
    }

    public void setResourceCodes(Set<String> resourceCodes) {
        this.resourceCodes = resourceCodes;
    }

    @JsonIgnore
    @Override
    public String token() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
