package com.xforceplus.tenant.security.token.jackson.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.*;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;

import java.io.IOException;

/**
 * @author geewit
 */
public class TokenUserSerializer<U extends TokenUser<R>, R extends TokenRole> extends JsonSerializer<U> {

    private final ObjectMapper objectMapper;

    public TokenUserSerializer() {
        objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(MapperFeature.DEFAULT_VIEW_INCLUSION);
    }

    @Override
    public void serialize(U value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        if (value.getId() != null) {
            generator.writeFieldName("id");
            generator.writeString(value.getId().toString());
        }
        if (value.getLoginId() != null) {
            generator.writeFieldName("loginId");
            generator.writeString(value.getLoginId());
        }
        if (value.getTenantId() != null) {
            generator.writeFieldName("tenantId");
            generator.writeString(value.getTenantId().toString());
        }
        if (value.getTenantCode() != null) {
            generator.writeFieldName("tenantCode");
            generator.writeString(value.getTenantCode());
        }
        if (value.getTenantName() != null) {
            generator.writeFieldName("tenantName");
            generator.writeString(value.getTenantName());
        }
        if (value.getAccountId() != null) {
            generator.writeFieldName("accountId");
            generator.writeString(value.getAccountId().toString());
        }
        if (value.getUsername() != null) {
            generator.writeFieldName("username");
            generator.writeString(value.getUsername());
        }
        if (value.getEmail() != null) {
            generator.writeFieldName("email");
            generator.writeString(value.getEmail());
        }
        if (value.getMobile() != null) {
            generator.writeFieldName("mobile");
            generator.writeString(value.getMobile());
        }
        if (value.getUserCode() != null) {
            generator.writeFieldName("userCode");
            generator.writeString(value.getUserCode());
        }
        if (value.getUserName() != null) {
            generator.writeFieldName("userName");
            generator.writeString(value.getUserName());
        }
        if (value.getModules() != null) {
            generator.writeFieldName("modules");
            generator.writeString(value.getModules());
        }
        if (value.getRoles() != null) {
            generator.writeFieldName("roles");
            generator.writeRawValue(objectMapper.writerWithView(provider.getActiveView()).writeValueAsString(value.getRoles()));
        }
        generator.writeEndObject();

    }
}
