package com.xforceplus.tenant.security.token.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 用户角色
 * @author geewit
 */
@ApiModel(description = "用户角色")
public interface IRole {
    /**
     * 用户角色id
     * @return 用户角色id
     */
    @ApiModelProperty("用户角色id")
    Long getId();

    /**
     * 租户id
     * @return 租户id
     */
    @ApiModelProperty("租户id")
    Long getTenantId();

    /**
     * 用户角色代码
     * @return 用户角色代码
     */
    @ApiModelProperty("用户角色代码")
    String getCode();

    /**
     * 用户角色名称
     * @return 用户角色名称
     */
    @ApiModelProperty("用户角色名称")
    String getName();
}
