package com.xforceplus.tenant.security.token.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TokenRole implements IRole {
    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户角色id")
    protected Long id;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("租户id")
    protected Long tenantId;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户角色代码")
    protected String code;

    @JsonView({View.class, TokenView.class})
    @ApiModelProperty("用户角色名称")
    protected String name;


    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenRole that = (TokenRole) o;
        return this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
