package com.xforceplus.tenant.security.token.domain;

/**
 * @author geewit
 */
public enum UserType {
    /**
     * 普通用户
     */
    USER("1", TokenKeys.USER_TOKEN_KEY, TokenKeys.USER_NAME_KEY, TokenKeys.USER_INFO_NAME),
    /**
     * 内部用户
     */
    @Deprecated
    STAFF("1", TokenKeys.STAFF_TOKEN_KEY, TokenKeys.STAFF_NAME_KEY, TokenKeys.STAFF_INFO_NAME),
    /**
     * client用户
     */
    APPID("3", TokenKeys.APP_TOKEN_KEY, TokenKeys.APP_NAME_KEY, TokenKeys.APP_INFO_NAME);


    UserType(String value, String tokenKey, String usernameKey, String userinfoKey) {
        this.value = value;
        this.tokenKey = tokenKey;
        this.usernameKey = usernameKey;
        this.userinfoKey = userinfoKey;
    }

    private final String value;

    private final String tokenKey;

    private final String usernameKey;

    private final String userinfoKey;

    public String value() {
        return this.value;
    }

    public String tokenKey() {
        return this.tokenKey;
    }

    public String usernameKey() {
        return this.usernameKey;
    }

    public String userinfoKey() {
        return this.userinfoKey;
    }
}
