/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.token.helper;

import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import com.xforceplus.tenant.security.token.domain.UserType;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import io.geewit.utils.uuid.UUIDUtils;
import io.geewit.web.utils.JsonUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtHelper {
    private static final Logger logger = LoggerFactory.getLogger(JwtHelper.class);

    public static <R extends TokenRole> String generateTokenFromAuthorizedUser(TokenUser<R> user, String secret) {
        if (StringUtils.isBlank((CharSequence)user.getLoginId())) {
            user.setLoginId(UUIDUtils.randomUUID());
        }
        String userinfo = JsonUtils.toJson(user, TokenView.class);
        logger.info("userinfo = " + userinfo);
        String base64Info = CompressionUtils.encode((String)userinfo);
        logger.info("base64Info = " + base64Info);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("type", UserType.USER.value());
        claims.put("userid", String.valueOf(user.getId()));
        claims.put("userinfo", base64Info);
        String token = JwtUtils.getToken((String)secret, claims);
        logger.info("token = {}", (Object)token);
        return token;
    }
}

