/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.security.token.decoder;

import com.auth0.jwt.exceptions.TokenExpiredException;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtDecoder {
    private static final Logger logger = LoggerFactory.getLogger(JwtDecoder.class);

    public static Map<String, String> decode(String token, String secret) {
        Map claims = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                claims = JwtUtils.verifyAndDecodeToken((String)secret, (String)token);
            }
            catch (TokenExpiredException e) {
                logger.error("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
                String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                logger.warn(message);
                return null;
            }
            catch (Exception e) {
                String message = "token\u89e3\u6790\u5931\u8d25";
                logger.error(message + ", secret = " + secret + ", token=" + token, (Throwable)e);
                return null;
            }
        }
        if (claims == null) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            logger.warn("claims == null, " + message);
            return null;
        }
        return claims;
    }

    public static String parseUserInfoFromClaims(Map<String, String> claims) {
        if (claims == null) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            logger.warn("claims == null, " + message);
            return null;
        }
        String systemType = claims.get("type");
        if (!UserType.USER.value().equals(systemType)) {
            String message = "token\u975e\u6cd5\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            logger.warn("claims == null, " + message);
            return null;
        }
        String encodedUserInfo = claims.get("userinfo");
        if (StringUtils.isBlank((CharSequence)encodedUserInfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            logger.warn("userinfo isBlank, " + message);
            return null;
        }
        return encodedUserInfo;
    }

    public static String parseUserInfoFromToken(String token, String secret) {
        Map<String, String> claims = JwtDecoder.decode(token, secret);
        return JwtDecoder.parseUserInfoFromClaims(claims);
    }
}

