/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgCompanyQueryBo.java   2020-11-26 14-40-15
 * Author: Evan
 */
package com.xforceplus.bo.org;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;

/**
 * <p>
 * Title: 查询请求参数
 * </p>
 * <p>
 * Description: 查询请求参数（公司税号（必填）+租户ID（可选）+组织ID（可选）+公司ID（可选））
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-11-26 14-40-15
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class OrgCompanyQueryBo {
    /**
     * 公司税号查询（必填）
     */
    @NotBlank(message = "公司税号不能为空")
    private String taxNum;

    /**
     * 公司ID(选填)
     */
    @Range(min = 0L, message = "公司ID必须大于0")
    private Long companyId;
    /**
     * 租户ID(选填)
     */
    @Range(min = 0L, message = "租户ID必须大于0")
    private Long tenantId;

    /**
     * 组织Id(选填)
     */
    @Range(min = 0L, message = "组织ID必须大于0")
    private Long orgId;

    private String tenantCode;
}
