/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgPageQueryBo.java   2020-11-30 11-11-02
 * Author: Evan
 */
package com.xforceplus.bo.org;

import com.xforceplus.tenant.security.core.domain.OrgType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * <p>
 * Title: OrgPageQueryBo
 * </p>
 * <p>
 * Description: OrgPageQueryBo
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-11-30 11-11-02
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class OrgPageQueryBo implements Serializable {

    /**
     * 组织类型
     */
    private OrgType type;

    private Boolean withUserBoundFlag;
    /**
     * 是否返回根节点
     */
    private Boolean withNoRootOrg;

    /**
     * 是否返回根节点
     * 如果参数值为null,则返回false
     *
     * @return Boolean
     */
    public Boolean getWithNoRootOrg() {
        if (withNoRootOrg == null) {
            return Boolean.FALSE;
        }
        return withNoRootOrg;
    }
}
