/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: OrgUserStatisticsQueryBo.java   2020-11-30 11-58-55
 * Author: Evan
 */
package com.xforceplus.bo.org;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Collections;
import java.util.Set;

/**
 * <p>
 * Title:  统计组织下用户数据
 * </p>
 * <p>
 * Description: 统计组织下用户数据
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-11-30 11-58-55
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class OrgUserStatisticsQueryBo {
    /**
     * 列表查询
     */
    private Set<Long> orgIds;

    /**
     * 如果值为null,则返回空的集合对象
     *
     * @return List<Long>
     */
    public Set<Long> getOrgIds() {
        if (this.orgIds == null) {
            return Collections.emptySet();
        }
        return this.orgIds;
    }
}
