package com.xforceplus.dao;

import com.xforceplus.entity.ClientResourcesetRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

/**
 * @author zhouxin
 */
public interface ClientResourcesetRelDao extends JpaRepository<ClientResourcesetRel, Long>, PagingAndSortingRepository<ClientResourcesetRel, Long>, JpaSpecificationExecutor<ClientResourcesetRel>, JpaBatchExecutor<ClientResourcesetRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ClientResourcesetRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    List<ClientResourcesetRel> findByClientId(String clientId);

    void deleteByClientId(String clientId);
}