package com.xforceplus.dao;

import com.xforceplus.entity.ClientTenantRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * @author geewit
 */
public interface ClientTenantRelDao extends JpaRepository<ClientTenantRel, Long>, PagingAndSortingRepository<ClientTenantRel, Long>, JpaSpecificationExecutor<ClientTenantRel>, JpaBatchExecutor<ClientTenantRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ClientTenantRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    List<ClientTenantRel> findByClientId(String clientId);

    void deleteByClientId(String clientId);
}
