package com.xforceplus.dao;

import com.xforceplus.api.model.CompanyModel;
import com.xforceplus.api.model.CompanyModel.Request.CompanyPackageQuery;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.domain.company.CompanyPackage;
import com.xforceplus.dto.company.CompanyServicePackageDTO;
import com.xforceplus.entity.Company;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;

import javax.persistence.Tuple;
import java.util.List;
import java.util.Optional;
import java.util.Set;


/**
 * 公司扩展查询
 *
 * @author geewit
 * @author Evan
 */
public interface CompanyCustomizedDao {

    /**
     * @param query
     * @param pageable
     * @return
     * @author geewit
     * 公司服务包查询
     */
    Page<CompanyPackage> findPackages(@Param("query") CompanyPackageQuery query, Pageable pageable);


    /**
     * @param companyIds 公司ID集合
     * @return List<CompanyServicePackageDTO>
     * @author Evan
     * 根据公司ID查询信息
     */
    List<CompanyServicePackageDTO> findCompanyServicePackageByCompanyIds(Set<Long> companyIds);

    /**
     * 分页通用查询的Tuple模式
     * @param query    查询参数
     * @param pageable 分页参数
     * @return
     */
    Page<Tuple> findTuples(CompanyModel.Request.Query query, Pageable pageable);

    /**
     * 根据公司履历的税号查询当前公司信息
     *
     * @param taxNum 历史税号
     * @return Optional<Company>
     */
    Optional<Company> findCompanyHistoryByTaxNum(String taxNum);

    /**
     * 按税号查询公司修改的履历信息
     *
     * @param taxNum   税号
     * @param pageable 分页
     * @return Page<CompanyHisDTO
     */
    Page<CompanyHisDTO> pageHistoryByTaxNum(String taxNum, Pageable pageable);
}
