package com.xforceplus.dao;

import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.entity.ServicePackage;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface CompanyServiceRelDao extends JpaRepository<CompanyServiceRel, Long>, JpaSpecificationExecutor<CompanyServiceRel>, JpaBatchExecutor<CompanyServiceRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyServiceRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Query("select csr.servicePackage from CompanyServiceRel csr where csr.tenantId = :tenantId and csr.status = 1 and csr.servicePackage.status = 1")
    List<ServicePackage> findByTenantId(@Param("tenantId") long tenantId);

    @Query("select new org.apache.commons.lang3.tuple.MutablePair(csr.companyId, csr.servicePackage) from CompanyServiceRel csr where csr.tenantId = :tenantId and csr.status = 1 and csr.servicePackage.status = 1")
    List<MutablePair<Long, ServicePackage>> findPairsByTenantId(@Param("tenantId") long tenantId);

    /**
     * 根据租户id和公司id查询公司服务包
     * @param tenantId 租户id
     * @param companyId 公司id
     * @return
     */
    List<CompanyServiceRel> findByTenantIdEqualsAndCompanyIdEquals(@Param("tenantId") long tenantId, @Param("companyId") long companyId);

    @Modifying(flushAutomatically = true)
    @Query("update CompanyServiceRel rel set rel.status = :status, rel.operateReason = :reason where rel.tenantId = :tenantId and rel.companyId = :companyId")
    void updateStatus(@Param("tenantId") long tenantId, @Param("companyId") long companyId, @Param("status") int status, @Param("reason") String reason);

    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyServiceRel rel where rel.servicePackageId = :servicePackageId")
    void deleteByPackageId(@Param("servicePackageId") long servicePackageId);

    long countByServicePackageId(long servicePackageId);


    @Modifying(clearAutomatically = true)
    @Query("delete from CompanyServiceRel rel where rel.servicePackageId = :servicePackageId and rel.tenantId = :tenantId")
    void deleteCompanyPackageByPackageIdAndTenantId(@Param("servicePackageId") long servicePackageId, @Param("tenantId") long tenantId);

    @Query(value = "select csr.* from bss_company_service_rel csr"
            + " left join bss_tenant t on csr.tenant_id = t.tenant_id"
            + " left join bss_company c on csr.company_id = c.company_id"
            + " left join bss_service_package sp on csr.service_package_id = sp.service_package_id"
            + " where t.tenant_code = :tenantCode"
            + " and c.tax_num = :taxNum"
            + " and sp.service_package_code = :packageCode", nativeQuery = true)
    List<CompanyServiceRel> findByTenantCodeAndTaxNumAndPackageCode(@Param("tenantCode") String tenantCode, @Param("taxNum") String taxNum, @Param("packageCode") String packageCode);

    @Modifying(flushAutomatically = true)
    @Query("update CompanyServiceRel rel set rel.tenantId = :tenantId where rel.id in (:companyPackageIds)")
    void batchUpdateTenant(@Param("companyPackageIds") List<Long> companyPackageIds, @Param("tenantId") long tenantId);


    @Query(value = "SELECT csr.service_package_id as packageId, count(rrr.role_id) as cnt" +
            " FROM" +
            " bss_company_service_rel AS csr" +
            " LEFT JOIN" +
            " bss_service_resourceset_rel AS ssr" +
            " ON" +
            " csr.service_package_id = ssr.service_package_id" +
            " LEFT JOIN" +
            " sys_role_resourceset_rel AS rrr" +
            " ON" +
            " ssr.resourceset_id = rrr.resouseset_id" +
            " AND csr.tenant_id = rrr.tenant_id" +
            " LEFT JOIN sys_role AS r" +
            " ON" +
            " r.role_id = rrr.role_id" +
            " WHERE" +
            " csr.tenant_id = :tenantId" +
            " AND csr.company_id = :companyId" +
            " AND csr.service_package_id in :packageIds" +
            " AND r.status = 1" +
            " GROUP BY" +
            " csr.service_package_id", nativeQuery = true)
    List<Map<String, Object>> countCompanyPackagesWereBoundByRole(@Param("tenantId") long tenantId,
                                                                  @Param("companyId") long companyId,
                                                                  @Param("packageIds") Set<Long> packageIds);

    @Query(value = "SELECT csr.service_package_id as packageId" +
            " FROM" +
            " bss_company_service_rel AS csr" +
            " LEFT JOIN" +
            " bss_service_resourceset_rel AS ssr" +
            " ON" +
            " csr.service_package_id = ssr.service_package_id" +
            " WHERE" +
            " csr.tenant_id = :tenantId" +
            " AND csr.company_id = :companyId" +
            " AND csr.service_package_id in :packageIds" +
            " GROUP BY" +
            " csr.service_package_id", nativeQuery = true)
    List<Long> findPackageIdsByTenantIdAndCompanyId(@Param("tenantId") long tenantId, @Param("companyId") long companyId, @Param("packageIds") Set<Long> packageIds);
}