package com.xforceplus.dao;

import com.xforceplus.entity.CompanyTenantRelAudit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface CompanyTenantRelAuditDao extends JpaRepository<CompanyTenantRelAudit, Long>, JpaSpecificationExecutor<CompanyTenantRelAudit> {
    @Query(value = "select * from company_tenant_rel_audit where rel_id = :relId and (switch_additions & :onSwitches) > 0 order by create_time desc", nativeQuery = true)
    List<CompanyTenantRelAudit> findAuditsByRelId(@Param("relId") long relId, @Param("onSwitches") int onSwitches);
}
