package com.xforceplus.dao;

import com.xforceplus.entity.CompanyTenantRel;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface CompanyTenantRelDao extends EntityGraphJpaRepository<CompanyTenantRel, Long>, EntityGraphJpaSpecificationExecutor<CompanyTenantRel>, JpaBatchExecutor<CompanyTenantRel> {

    List<CompanyTenantRel> findByCompanyId(long companyId);

    List<CompanyTenantRel> findByTenantId(long tenantId);

    @Query("select rel from CompanyTenantRel rel where rel.companyId = :companyId and rel.relatedTenantId = :relatedTenantId")
    List<CompanyTenantRel> findCompanyIdAndRelatedTenantId(@Param("companyId") long companyId, @Param("relatedTenantId") long relatedTenantId);

    List<CompanyTenantRel> findByTenantIdAndCompanyId(long tenantId, long companyId);

    /**
     * 根据 关联租户id, 公司id, 被关联租户code 获取 CompanyTenantRel
     * @param tenantId 关联租户id
     * @param companyId 公司id
     * @param relatedTenantId 被关联租户Id
     * @return CompanyTenantRel
     */
    @Query("select rel from CompanyTenantRel rel where rel.companyId = :companyId and rel.tenantId = :tenantId and rel.relatedTenantId = :relatedTenantId")
    CompanyTenantRel findByTenantIdAndCompanyIdAndRelatedTenantId(@Param("tenantId") long tenantId, @Param("companyId") long companyId, @Param("relatedTenantId") long relatedTenantId);

    /**
     * 根据 关联租户id, 公司id, 被关联租户id 获取 CompanyTenantRel
     * @param tenantId 关联租户id
     * @param companyId 公司id
     * @param relatedTenantId 被关联租户id
     * @return CompanyTenantRel
     */
    @Query("select rel from CompanyTenantRel rel where rel.companyId = :companyId and rel.tenantId = :tenantId and rel.relatedTenantId = :relatedTenantId")
    CompanyTenantRel findByCompanyIdAndTenantIdAndRelatedTenantId(@Param("companyId") long companyId, @Param("tenantId") long tenantId, @Param("relatedTenantId") long relatedTenantId);
}
