package com.xforceplus.dao;

import com.xforceplus.entity.CompanyTenantRelOperation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * 公司租户关联关系操作记录 Dao
 *
 * @author : geewit
 * Date: 21-04-30
 */
public interface CompanyTenantRelOperationDao extends JpaRepository<CompanyTenantRelOperation, Long>, JpaSpecificationExecutor<CompanyTenantRelOperation>, CompanyTenantRelOperationCustomizedDao {

    @Query("select o from CompanyTenantRelOperation o where o.companyId = :companyId and o.tenantId = :tenantId and o.relatedTenantId = :relatedTenantId and o.operationType = :#{T(com.xforceplus.domain.company.CompanyTenantRelOperationDto).OPERATION_TYPE_INVITE} and o.status = :#{T(com.xforceplus.domain.company.CompanyTenantRelOperationDto$Status).INITED.value()}")
    List<CompanyTenantRelOperation> findInvitionsByTenantIdAndCompanyIdAndRelatedTenantId(@Param("tenantId") long tenantId, @Param("companyId") long companyId, @Param("relatedTenantId") long relatedTenantId);
}
