package com.xforceplus.dao;

import com.xforceplus.entity.OrgCompanyRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Collection;
import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface OrgCompanynoDao extends JpaRepository<OrgCompanyRel, Long>, JpaSpecificationExecutor<OrgCompanyRel>, JpaBatchExecutor<OrgCompanyRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from OrgCompanyRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Query("select r from OrgCompanyRel r where r.orgStructId = :orgId")
    List<OrgCompanyRel> findByOrgId(@Param("orgId") long orgId);

    /**
     * 查询列表
     *
     * @param orgIds
     * @return List<OrgCompanyRel>
     */
    @Query(" select r from OrgCompanyRel r where r.orgStructId in(:orgIds) ")
    List<OrgCompanyRel> findByOrgIds(@Param("orgIds") List<Long> orgIds);


    @Modifying(clearAutomatically = true)
    @Query("delete from OrgCompanyRel r where r.orgStructId = :orgId")
    void deleteByOrgId(@Param("orgId") long orgId);

    @Query("select new org.apache.commons.lang3.tuple.MutablePair(rel.orgStructId, rel.companyNo) from OrgCompanyRel rel where rel.orgStructId in :orgIds")
    List<Pair<Long, String>> findCompanyNosPairsByOrgIds(@Param("orgIds") Collection<Long> orgIds);
}
