package com.xforceplus.dao;

import com.xforceplus.api.model.OrgModel.Request.*;
import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.bo.org.OrgUserStatisticsQueryBo;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.dto.org.OrgCompanyNoDTO;
import com.xforceplus.dto.org.OrgParentDTO;
import com.xforceplus.dto.org.OrgUserStatisticsDTO;
import com.xforceplus.entity.OrgStruct;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import javax.persistence.Tuple;
import java.util.Collection;
import java.util.List;

/**
 * @author geewit
 */
public interface OrgStructCustomizedDao {

    /**
     * 获取组织子孙列表
     * @param orgId
     * @return
     */
    List<OrgStruct> findDescendantsById(long orgId);

    /**
     * 分页通用查询的Tuple模式
     * @param query    查询参数
     * @param pageable 分页参数
     * @return
     */
    Page<Tuple> findTuples(Query query, Pageable pageable);

    /**
     * 列表通用查询的Tuple模式
     * @param query    查询参数
     * @param sort     分页参数
     * @return
     */
    List<Tuple> findTuples(Query query, Sort sort);

    List<OrgStruct> findRelatedCompaniesByUserId(long userId);

    /**
     * 查询该用户关联的 role 所分配的所有资源码信息
     *
     * @param userId userId
     * @return List<ResourceDTO>
     */
    List<OrgDto> getOrgByTenantCodeAndOrgCode(String tenantCode, String orgCode);

    /**
     * 根据税号查询
     *
     * @param queryBo 查询参数
     * @return List<OrgCompanyDTO>
     */
    List<OrgCompanyDTO> findOrgCompanyByTaxNum(OrgCompanyQueryBo queryBo);

    /**
     * 查询每个组织组织用户数据统计
     *
     * @param queryBo
     * @return List<OrgUserStatisticsDTO>
     */
    List<OrgUserStatisticsDTO> findUserStatisticsByOrgIds(OrgUserStatisticsQueryBo queryBo);

    /**
     * 查询父组组织信息
     *
     * @param orgIds 组织ID列表
     * @return List<OrgParentDTO> 父组组织信息
     */
    List<OrgParentDTO> findOrgParentByOrgIds(Collection<Long> orgIds);

    /**
     * 根据组织IDs查询
     *
     * @param orgIds 组织IDs
     * @return List<OrgCompanyNoDTO>
     */
    List<OrgCompanyNoDTO> findCompanyNoByOrgIds(Collection<Long> orgIds);
}
