package com.xforceplus.dao;

import com.xforceplus.entity.OrgUserRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;

import java.util.Collection;
import java.util.List;
import java.util.Set;


/**
 * 组织-用户-关系表 Dao
 *
 * @author : geewit
 * Date: 19-12-03
 */
public interface OrgUserRelDao extends JpaRepository<OrgUserRel, Long>, JpaSpecificationExecutor<OrgUserRel>, JpaBatchExecutor<OrgUserRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Query("select rel from OrgUserRel rel where rel.userId = :userId")
    List<OrgUserRel> findByUserId(@Param("userId") long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.orgStructId in :orgIds")
    void deleteByTenantIdAndUserIdAndOrgIds(@Param("tenantId") long tenantId, @Param("userId") long userId, @Param("orgIds") Collection<Long> orgIds);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.userId = :userId")
    void deleteByUserId(@Param("userId") long userId);

    @Query("select rel.orgStructId from OrgUserRel rel where rel.userId = :userId")
    List<Long> findOrgIdsByUserId(@Param("userId") long userId);

    List<OrgUserRel> findByTenantId(Long tenantId);

    @Query("select rel from OrgUserRel rel where rel.tenantId = :tenantId and rel.orgStructId in :orgIds")
    Set<OrgUserRel> findRelsByTenantIdAndOrgIds(@Param("tenantId") long tenantId, @Param("orgIds") Collection<Long> orgIds);

    @Query("select rel from OrgUserRel rel where rel.orgStructId in :orgIds")
    Set<OrgUserRel> findRelsByOrgIds(@Param("orgIds") Collection<Long> orgIds);

    @Modifying(flushAutomatically = true)
    @Query("update OrgUserRel rel set rel.tenantId = :tenantId where rel.id in :orgUserRelIds")
    void batchUpdateTenant(@Param("orgUserRelIds") List<Long> roleUserRelIds, @Param("tenantId") Long tenantId);

    @Modifying(clearAutomatically = true)
    @Query("delete from OrgUserRel rel where rel.orgStructId in :orgIds")
    void deleteByOrgIds(@Param("orgIds") Set<Long> orgIds);

    @Query(value = "select count(rel.user_id) from sys_org_user_rel rel where rel.org_struct_id = :orgId", nativeQuery = true)
    long countByOrgId(@Param("orgId") long orgId);

    @Query("select rel.userId from OrgUserRel rel where rel.tenantId = :tenantId and rel.orgStructId = :orgId")
    Set<Long> findUserIdByTenantIdAndOrgId(@Param("tenantId") long tenantId, @Param("orgId") long orgId);
}