package com.xforceplus.dao;

import com.xforceplus.entity.OrgVirtualOrgStructRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/**
* @copyright © 上海云砺信息科技有限公司
* @author zhouxin
* @date 2021/8/4 11:02
*/
@SuppressWarnings("all")
public interface OrgVirtualOrgStructDao extends JpaRepository<OrgVirtualOrgStructRel, Long>, JpaSpecificationExecutor<OrgVirtualOrgStructRel>, JpaBatchExecutor<OrgVirtualOrgStructRel> {

    /**
     * 根据租户id和虚拟组织id和行政组织id查询
     * @param tenantId
     * @param orgVirtualId
     * @param orgStructId
     * @return
     */
    Optional<OrgVirtualOrgStructRel> findByTenantIdAndOrgVirtualIdAndOrgStructId(Long tenantId, Long orgVirtualId, Long orgStructId);

    /**
     * 根据租户id和虚拟组织id删除
     * @param tenantId
     * @param orgVirtualId
     */
    @Modifying(clearAutomatically = true)
    @Query("delete from OrgVirtualOrgStructRel rel where rel.tenantId = :tenantId and rel.orgVirtualId = :orgVirtualId")
    void deleteByTenantIdAndOrgVirtualId(@Param("tenantId")Long tenantId, @Param("orgVirtualId")Long orgVirtualId);
}
