package com.xforceplus.dao;

import com.xforceplus.entity.OrgVirtualNodeUserRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/21 18:47
 * 功能描述:
 * 修改历史:
 */
public interface OrgVirtualUserRelDao extends JpaRepository<OrgVirtualNodeUserRel, Long>, JpaSpecificationExecutor<OrgVirtualNodeUserRel>, JpaBatchExecutor<OrgVirtualNodeUserRel> {

    List<OrgVirtualNodeUserRel> findByOrgVirtualNodeId(Long nodeId);

    @Modifying
    @Query("delete from OrgVirtualNodeUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.orgVirtualNodeId = :orgVirtualNodeId")
    void deleteByTenantIdAndUserIdAndOrgVirtualNodeId(@Param("tenantId") Long tenantId,
                                                      @Param("userId") Long userId,
                                                      @Param("orgVirtualNodeId") Long orgVirtualNodeId);

    @Modifying
    @Query("delete from OrgVirtualNodeUserRel rel where rel.tenantId = :tenantId and rel.userId in :userIds and rel.orgVirtualNodeId = :orgVirtualNodeId")
    void deleteByUserIdsAndNodeId(@Param("tenantId") Long tenantId,
                                  @Param("userIds") List<Long> userIds,
                                  @Param("orgVirtualNodeId") Long orgVirtualNodeId);

    Optional<OrgVirtualNodeUserRel> findByOrgVirtualNodeIdAndTenantIdAndUserId(Long nodeId, Long tenantId, Long userId);

    Optional<OrgVirtualNodeUserRel> findByOrgVirtualNodeIdAndUserId(Long nodeId, Long userId);

    Set<OrgVirtualNodeUserRel> findByOrgVirtualNodeIdIn(Set<Long> nodeId);

}
