/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceExtendDao.java   2020-10-20 11-18-12
 * Author: Evan
 */
package com.xforceplus.dao;

import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.dto.resource.ResourceDTO;
import com.xforceplus.dto.resource.ResourceServiceApiDTO;
import com.xforceplus.dto.resource.ServiceApiRouterDTO;
import com.xforceplus.dto.resource.ServicePackageDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.NoRepositoryBean;

import java.util.List;

/**
 * <p>
 * Title: ResourceExtendDao扩展接口定义
 * </p>
 * <p>
 * Description: ResourceExtendDao扩展接口定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-20 11-18-12
 * @since V1.0
 */
@NoRepositoryBean
public interface ResourceExtendDao {
    /**
     * 查询所有路由信息
     *
     * @return List<ServiceApiRouterDTO>
     */
    List<ServiceApiRouterDTO> findRouteAll();

    /**
     * 分页查询
     *
     * @param pageable 分页对象
     * @param queryBo  分页查询条件
     * @return Page<Resource>
     */
    Page<ResourceDTO> pagingBy(Pageable pageable, ResourceQueryBo queryBo);

    /**
     * 服务API分页查询
     *
     * @param pageable 分页查询条件
     * @param queryBo  分页对象
     * @return Page<ServiceApiDTO>
     */
    Page<ResourceServiceApiDTO> pagingByServiceApi(Pageable pageable, ResourceQueryBo queryBo);

    /**
     * 查询该用户关联的 role 所分配的所有资源码信息
     *
     * @param userId userId
     * @return List<ResourceDTO>
     */
    List<ResourceDTO> getUserRoleResourceCode(Long userId);


    List<ServicePackageDTO> getServicePackIdByUserIdAndAppId(Long userId, Long appId);

    List<ResourceDTO> getUserCompanyResourceByPackageIdList(List<Long> servicePackageList);
}
