package com.xforceplus.dao;

import com.xforceplus.entity.ResourcesetResourceRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ResourcesetResourceRelDao extends JpaRepository<ResourcesetResourceRel, Long>, JpaSpecificationExecutor<ResourcesetResourceRel>, JpaBatchExecutor<ResourcesetResourceRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ResourcesetResourceRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    List<ResourcesetResourceRel> findByResourcesetId(Long resourcesetId);

    /**
     * 根据资源码和功能集Id
     *
     * @param resourcesetId 功能集ID
     * @param resourceId    资源码Id
     * @return List<ResourcesetResourceRel>
     */
    List<ResourcesetResourceRel> findByResourcesetIdAndResourceId(Long resourcesetId, Long resourceId);

    @Modifying(clearAutomatically = true)
    @Query("delete from ResourcesetResourceRel rel where rel.resourceId = :resourceId")
    void deleteByResourceId(@Param("resourceId") long resourceId);

    @Modifying(clearAutomatically = true)
    @Query("delete from ResourcesetResourceRel rel where rel.resourcesetId = :resourcesetId")
    void deleteByResourcesetId(@Param("resourcesetId") long resourcesetId);

}
