package com.xforceplus.dao;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.domain.tenant.RoleExportDto;
import com.xforceplus.domain.tenant.RoleRelAccountExportDto;
import com.xforceplus.domain.tenant.RoleResourceDTO;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 角色扩展查询
 *
 * @author geewit
 * @author Evan
 */
public interface RoleCustomizedDao {

    List<RoleExportDto> findRolesResourcesetRel(Long tenantId, RoleModel.Request.Export query, Pageable pageable);

    List<RoleRelAccountExportDto> findRolesRelAccount(Long tenantId, RoleModel.Request.Export query, Pageable pageable);

    /**
     * 按角色ID查询
     *
     * @param roleId 角色ID
     * @param status 状态
     * @return List<RoleResourceDTO>
     */
    List<RoleResourceDTO> findResourceSetByRoleId(Long roleId, Integer status);
}
