package com.xforceplus.dao;

import com.xforceplus.domain.tenant.OrgRoleCntDTO;
import com.xforceplus.domain.tenant.RoleUserCntDTO;
import com.xforceplus.entity.Role;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface RoleDao extends JpaRepository<Role, Long>, JpaSpecificationExecutor<Role>, JpaBatchExecutor<Role>, RoleCustomizedDao {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Role r where r.id = :id")
    void deleteById(@Param("id") Long id);

    /***
     * 根据角色名称列表
     * @param name 角色
     * @return List<Role>
     */
    @Query("select r from Role r where r.name = :name")
    List<Role> findByName(@Param("name") String name);

    /***
     * 根据ID查询角色名称，不等于当前ID
     * @param name 角色
     * @param roleId 角色
     * @return List<Role>
     */
    @Query("select r from Role r where r.name = :name and r.id<>:roleId")
    List<Role> findByNameAndId(@Param("name") String name, @Param("roleId") Long roleId);


    @Query("select r from Role r where r.tenantId = :tenantId and r.code in (:roleCodes)")
    List<Role> findByTenantIdAndRoleCodes(@Param("tenantId") long tenantId, @Param("roleCodes") Collection<String> roleCodes);

    @Modifying
    @Query("update Role r set r.status = :status where r.id = :roleId and r.tenantId = :tenantId")
    int updateStatus(@Param("tenantId") long tenantId, @Param("roleId") long roleId, @Param("status") int status);

    @Modifying
    @Query("update Role r set r.status = :status where r.id = :roleId")
    int updateStatus(@Param("roleId") long roleId, @Param("status") int status);

    @Query("select r from Role r where r.tenantId = :tenantId and r.fromRoleId =:fromRoleId")
    Role findByTenantIdAndFromRoleId(@Param("tenantId") long tenantId, @Param("fromRoleId") long fromRoleId);

    @Query("select r.id from Role r where r.tenantId = :tenantId and r.code =:roleCode")
    Long findIdByTenantIdAndCode(@Param("tenantId") long tenantId, @Param("roleCode") String roleCode);

    @Query("select r from Role r where r.tenantId = :tenantId and r.code =:roleCode")
    Role findByTenantIdAndCode(@Param("tenantId") long tenantId, @Param("roleCode") String roleCode);


    @Query("select r from Role r where r.tenantId = :tenantId and r.code =:roleCode")
    List<Role> findByListTenantIdAndCode(@Param("tenantId") long tenantId, @Param("roleCode") String roleCode);

    @Query("select count(r.id) from Role r where r.tenantId = :tenantId and r.code =:roleCode and r.id <> :currentId")
    long countDifferentByTenantIdAndCode(@Param("tenantId") long tenantId, @Param("currentId") long currentId, @Param("roleCode") String roleCode);

    @Query("select count(r.id) from Role r where r.tenantId = :tenantId and r.name =:roleName and r.id <> :currentId")
    long countDifferentByTenantIdAndName(@Param("tenantId") long tenantId, @Param("currentId") long currentId, @Param("roleName") String roleName);

    List<Role> findByTenantId(Long oldTenantId);

    @Modifying(flushAutomatically = true)
    @Query("update Role r set r.tenantId = :tenantId where r.id in (:roleIds)")
    void batchUpdateTenant(@Param("roleIds") List<Long> roleIds, @Param("tenantId") Long tenantId);

    @Query("select new com.xforceplus.domain.tenant.OrgRoleCntDTO(r.fromRoleId, count(r.id)) from Role r where r.tenantId = :tenantId and r.fromRoleId in :roleIds and r.status =1 and r.type = 2 group by r.fromRoleId")
    List<OrgRoleCntDTO> getOrgRoleCntByGradingRoleIds(@Param("tenantId") Long tenantId,@Param("roleIds") Set<Long> roleIds);

    @Query("select new com.xforceplus.domain.tenant.RoleUserCntDTO(r.id, count(rel.id)) from Role r left join com.xforceplus.entity.RoleUserRel rel on rel.roleId = r.id where r.tenantId = :tenantId and r.id in :roleIds group by r.id")
    List<RoleUserCntDTO> getRoleUserCntByRoleIds(@Param("tenantId") Long tenantId,@Param("roleIds") Set<Long> roleIds);

    @Modifying(flushAutomatically = true)
    @Query("update Role r set r.status = 0 where r.fromRoleId = :roleId")
    void disableOrgRolesByGradingRoleId(@Param("roleId") Long roleId);
}
