package com.xforceplus.dao;

import com.xforceplus.entity.RoleResourcesetRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface RoleResourcesetRelDao extends JpaRepository<RoleResourcesetRel, Long>, JpaSpecificationExecutor<RoleResourcesetRel>, JpaBatchExecutor<RoleResourcesetRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from RoleResourcesetRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Override
    List<RoleResourcesetRel> findAll();

    List<RoleResourcesetRel> findByRoleId(long roleId);

    @Query("select r from RoleResourcesetRel r where r.roleId = :roleId and r.resousesetId =:resousesetId and r.tenantId=:tenantId")
    RoleResourcesetRel findByRoleIdAndResourcesetIdAndTenantId(@Param("roleId") long roleId, @Param("resousesetId") long resousesetId, @Param("tenantId") long tenantId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleResourcesetRel rel where rel.roleId = :roleId")
    void deleteByRoleId(@Param("roleId") long roleId);

    @Query(value = "SELECT rrr.resouseset_id as resourcesetId, count(rrr.role_id) as cnt" +
            " FROM" +
            " sys_role_resourceset_rel AS rrr" +
            " LEFT JOIN" +
            " bss_service_resourceset_rel AS ssr" +
            " ON" +
            " ssr.resourceset_id = rrr.resouseset_id" +
            " LEFT JOIN sys_role AS r" +
            " ON" +
            " r.role_id = rrr.role_id" +
            " WHERE" +
            " ssr.service_package_id = :packageId" +
            " AND rrr.resouseset_id in :resourcesetIds" +
            " AND r.status = 1" +
            " GROUP BY" +
            " rrr.resouseset_id", nativeQuery = true)
    List<Map<String, Object>> countResourcesetsWereBoundByRole(@Param("packageId") long packageId, @Param("resourcesetIds") Set<Long> resourcesetIds);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleResourcesetRel rel where rel.roleId = :roleId and rel.resousesetId in :bindedResourcesetIds")
    void unbindGradingRoleResourcesets(@Param("roleId")Long roleId, @Param("bindedResourcesetIds")Set<Long> bindedResourcesetIds);
}
