package com.xforceplus.dao;

import com.xforceplus.entity.RoleUserRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;

import java.util.Collection;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface RoleUserRelDao extends JpaRepository<RoleUserRel, Long>, JpaSpecificationExecutor<RoleUserRel>, JpaBatchExecutor<RoleUserRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    List<RoleUserRel> findByRoleId(long roleId);

    List<RoleUserRel> findByUserId(long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.roleId = :roleId")
    void deleteByTenantIdAndUserIdAndRoleId(@Param("tenantId") long tenantId, @Param("userId") long userId, @Param("roleId") Long roleId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.userId = :userId")
    void deleteByUserId(@Param("userId") long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.roleId = :roleId")
    void deleteByRoleId(@Param("roleId") long roleId);

    long countByRoleId(long roleId);

    List<RoleUserRel> findByTenantId(Long tenantId);

    @Modifying(flushAutomatically = true)
    @Query("update RoleUserRel rel set rel.tenantId = :tenantId where rel.id in (:roleUserRelIds)")
    void batchUpdateTenant(@Param("roleUserRelIds") List<Long> roleUserRelIds, @Param("tenantId") Long tenantId);

    List<RoleUserRel> findByRoleIdAndTenantId(long roleId, long tenantId);

    @Query("select rel.userId from RoleUserRel rel where rel.roleId = :roleId")
    List<Long> findUserIdsByRoleId(@Param("roleId") Long roleId);

    @Query("select rel.roleId from RoleUserRel rel inner join com.xforceplus.entity.Role r on rel.roleId = r.id where rel.userId = :userId and r.type = 1")
    Set<Long> findGradingRoleIdsByUserId(@Param("userId")Long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.roleId = :roleId and rel.userId in :userIds")
    void deleteByRoleIdAndUserIds(@Param("roleId")long roleId, @Param("userIds") Collection<Long> userIds);

    @Modifying(clearAutomatically = true)
    @Query("delete from RoleUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.roleId in :roleIds")
    void deleteByTenantIdAndUserIdAndRoleIds(@Param("tenantId") long tenantId, @Param("userId") long userId, @Param("roleIds") Collection<Long> roleIds);

    @Modifying(clearAutomatically = true)
    @Query("update RoleUserRel rel set rel.roleId = :newRoleId where rel.roleId = :existRoleId")
    void updateRoleId(@Param("existRoleId") long  existRoleId, @Param("newRoleId") long newRoleId);
}

