package com.xforceplus.dao;

import com.xforceplus.entity.ServicePackage;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ServicePackageDao extends JpaRepository<ServicePackage, Long>, JpaSpecificationExecutor<ServicePackage>, ServicePackageCustomizedDao {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ServicePackage sp where sp.servicePackageId = :id")
    void deleteById(@Param("id") Long id);

    List<ServicePackage> findServicePackagesByServicePackageCodeEqualsAndStatusEquals(String servicePackageCode, int i);

    @Query("select count(sp) from ServicePackage sp where sp.servicePackageId <> :servicePackageId and sp.servicePackageCode = :servicePackageCode")
    long countByNotCurrentPackageIdAndCode(@Param("servicePackageId") long servicePackageId, @Param("servicePackageCode") String servicePackageCode);

    @Query("select count(sp) from ServicePackage sp where sp.servicePackageId <> :servicePackageId and sp.appId = :appId and sp.servicePackageName = :servicePackageName")
    long countByNotCurrentPackageIdAndName(@Param("servicePackageId") long servicePackageId, @Param("appId") long appId, @Param("servicePackageName") String servicePackageName);

    /**
     * 根据servicePackageCodes查询
     *
     * @param servicePackageCode
     * @return List<ServicePackage>
     */
    List<ServicePackage> findByServicePackageCode(String servicePackageCode);
}
