package com.xforceplus.dao;

import com.xforceplus.entity.ServiceResourcesetRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface ServiceResourcesetRelDao extends JpaRepository<ServiceResourcesetRel, Long>, JpaSpecificationExecutor<ServiceResourcesetRel>, JpaBatchExecutor<ServiceResourcesetRel> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from ServiceResourcesetRel rel where rel.id = :id")
    void deleteById(@Param("id") Long id);

    @Override
    List<ServiceResourcesetRel> findAll();

    @Query("select srr.resourcesetId from ServiceResourcesetRel srr where srr.servicePackageId = :servicePackageId")
    List<Long> findResourcesetIdByServicePackageId(@Param("servicePackageId") Long servicePackageId);

    List<ServiceResourcesetRel> findByServicePackageId(Long servicePackageId);

    @Modifying(clearAutomatically = true)
    @Query("delete from ServiceResourcesetRel rel where rel.resourcesetId = :resourcesetId")
    void deleteByResourcesetId(@Param("resourcesetId") long resourcesetId);

    @Modifying(clearAutomatically = true)
    @Query("delete from ServiceResourcesetRel rel where rel.servicePackageId = :servicePackageId")
    void deleteByPackageId(@Param("servicePackageId") long servicePackageId);

    long countByResourcesetId(long resourcesetId);

    /**
     * 按服务包ID和功能集ID查询绑定关系
     *
     * @param servicePackageId 服务包ID
     * @param resourcesetId    功能集ID
     * @return List<ServiceResourcesetRel>
     */
    List<ServiceResourcesetRel> findByServicePackageIdAndResourcesetId(Long servicePackageId, Long resourcesetId);
}
