package com.xforceplus.dao;

import com.xforceplus.entity.SettleFlow;
import com.xforceplus.entity.SettleTemplate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleFlowDao extends JpaRepository<SettleFlow, Long>, JpaSpecificationExecutor<SettleFlow> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from SettleFlow sf where sf.flowId = :flowId")
    void deleteById(@Param("flowId") Long id);

    @Query("select sftr.template from SettleFlowTemplateRel sftr where sftr.flowId = :flowId order by sftr.pageIndex")
    List<SettleTemplate> findTemplateByFlowId(@Param("flowId") long flowId);

    Optional<SettleFlow> findByFlowCode(String flowCode);

    Optional<SettleFlow> findByTenantId(@Param("tenantId") Long tenantId);

    @Query("select sfp.packageId from SettleFlowPackage sfp where sfp.flowId = :flowId")
    List<Long> findPackageIdsByFlowId(@Param("flowId") long flowId);

}
