package com.xforceplus.dao;

import com.xforceplus.entity.SettleTemplateAttribute;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleTemplateAttributeDao extends JpaRepository<SettleTemplateAttribute, Long>, JpaSpecificationExecutor<SettleTemplateAttribute> {

    @Modifying(flushAutomatically = true)
    @Query("delete from SettleTemplateAttribute attr where attr.templateId = :templateId")
    void deleteByTemplateId(@Param("templateId") long templateId);
}
