package com.xforceplus.dao;

import com.xforceplus.entity.SettleTemplate;
import com.xforceplus.entity.SettleTemplateAttribute;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface SettleTemplateDao extends JpaRepository<SettleTemplate, Long>, JpaSpecificationExecutor<SettleTemplate> {

    @Override
    @EntityGraph(value = SettleTemplate.NAMED_ENTITY_GRAPH_DEFAULT, type = EntityGraph.EntityGraphType.FETCH)
    Optional<SettleTemplate> findById(Long templateId);

    @Query("select stsr.service.serviceCode from SettleTemplateServiceRel stsr where stsr.templateId = :templateId")
    List<String> findServiceCodesByTemplateId(@Param("templateId") long templateId);


    List<SettleTemplateAttribute> findAttributesByTemplateId(@Param("templateId") Long templateId);

    @Query("select rel.templateId from SettleFlowTemplateRel rel where rel.flowId = :flowId")
    List<Long> findTemplateIdByFlowId(@Param("flowId") long flowId);

}
