package com.xforceplus.dao;

import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantCompanyRel;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface TenantCompanyRelDao extends JpaRepository<TenantCompanyRel, Long>, JpaSpecificationExecutor<TenantCompanyRel>, JpaBatchExecutor<TenantCompanyRel> {
    /**
     * 查询所有关系功能信息
     *
     * @return
     */
    @SuppressWarnings("all")
    @Query(value = "select t.tenant_code as tenantCode, t.tenant_name as tenantName, rel.company_id as companyId from bss_tenant_company_rel rel INNER JOIN bss_tenant t on t.tenant_id = rel.tenant_id", nativeQuery = true)
    List<Object[]> findTenantCommpanyRelAll();

    List<TenantCompanyRel> findByCompanyId(long companyId);

    @Query("select rel.tenant from TenantCompanyRel rel where rel.companyId = :companyId")
    List<Tenant> findTenantsByCompanyId(@Param("companyId") long companyId);
}
