package com.xforceplus.dao;

import com.xforceplus.entity.Tenant;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Set;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface TenantDao extends JpaRepository<Tenant, Long>, JpaSpecificationExecutor<Tenant>, TenantCustomizedDao {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from Tenant t where t.tenantId = :tenantId")
    void deleteById(@Param("tenantId") Long id);

    @Query("select t.tenantId from Tenant t where t.tenantCode = :tenantCode")
    Long findTenantIdByTenantCode(@Param("tenantCode") String tenantCode);

    /**
     * 根据用户名称查询租户IDS
     *
     * @param tenantName 租户名称
     * @return List<Long> 租户ID集合
     */
    @Query("select t.tenantId from Tenant t where t.tenantName like :tenantName")
    Set<Long> findIdsByTenantName(@Param("tenantName") String tenantName);

    @Query("select o.tenant from com.xforceplus.entity.OrgStruct o where o.companyId = :companyId")
    List<Tenant> findByCompanyId(@Param("companyId") long companyId);


    @Query("select t from Tenant t where t.tenantCode = :tenantCode")
    Tenant findByTenantCode(@Param("tenantCode") String tenantCode);

}
