package com.xforceplus.dao;

import com.xforceplus.entity.TenantRelation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * @author : HWT
 * Date: 21-4-8
 */
public interface TenantRelationDao extends JpaRepository<TenantRelation, Long>,
        JpaSpecificationExecutor<TenantRelation> {

    @Query("select ten from TenantRelation ten where ten.parentTenantId = :tenantId or ten.childTenantId = :tenantId")
    List<TenantRelation> findByTenantId(@Param("tenantId") Long tenantId);


    @Query("select ten from TenantRelation ten where ten.parentTenantId = :parentTenantId and ten.childTenantId = :childTenantId")
    List<TenantRelation> findByParentTenantIdAndChildTenantId(@Param("parentTenantId") Long parentTenantId,
                                                              @Param("childTenantId") Long childTenantId);
}
