package com.xforceplus.dao;

import com.xforceplus.domain.tenant.GradingRoleUser;
import com.xforceplus.entity.User;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaRepository;
import io.geewit.data.jpa.essential.repository.EntityGraphJpaSpecificationExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface UserDao extends EntityGraphJpaRepository<User, Long>, EntityGraphJpaSpecificationExecutor<User>, UserCustomizedDao {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from User u where u.id = :userId")
    void deleteById(@Param("userId") Long id);

    Optional<User> findByTenantIdAndUserCode(long tenantId, String userCode);

    @Query("select u from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    List<User> findAllByTenantIdAndUserCode(@Param("tenantId") long tenantId, @Param("userCode") String userCode);

    @EntityGraph(value = User.NAMED_ENTITY_GRAPH_TENANT, type = EntityGraph.EntityGraphType.FETCH)
    List<User> findByAccountId(Long accountId);

    User findFirstByTenantIdAndAccountId(Long tenantId, Long accountId);

    @Query("select u.id from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    Long findIdByTenantIdAndCode(@Param("tenantId") long tenantId, @Param("userCode") String userCode);

    @Query("select u.id from User u where u.tenantId = :tenantId and u.userCode = :userCode")
    List<Long> findListByTenantIdAndUserCode(@Param("tenantId") Long tenantId, @Param("userCode") String userCode);

    List<User> findByTenantId(Long tenantId);

    @Modifying(flushAutomatically = true)
    @Query("update User u set u.tenantId = :tenantId where u.id in :userIds")
    void batchUpdateTenant(@Param("userIds") List<Long> userIds, @Param("tenantId") Long tenantId);

    List<User> findByAccountIdIn(Collection<Long> accountIds);

    @Query("select new com.xforceplus.domain.tenant.GradingRoleUser(a.username, a.telPhone, a.email) from User u inner join com.xforceplus.entity.Account a on u.accountId = a.accountId where u.id in :userIds")
    List<GradingRoleUser> findGradingRoleUserByUserIds(@Param("userIds") List<Long> userIds);
}
