package com.xforceplus.dao;

import com.xforceplus.entity.UserTag;
import io.geewit.data.jpa.essential.repository.JpaBatchExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface UserTagDao extends JpaRepository<UserTag, Long>, JpaSpecificationExecutor<UserTag>, JpaBatchExecutor<UserTag> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from UserTag tag where tag.id = :id")
    void deleteById(@Param("id") Long id);

    List<UserTag> findByUserId(Long userId);

    @Modifying(clearAutomatically = true)
    @Query("delete from UserTag tag where tag.userId = :userId")
    void deleteByUserId(@Param("userId") long userId);
}
