package com.xforceplus.dao.impl;

import com.xforceplus.api.model.CompanyTenantRelOperationModel.*;
import com.xforceplus.dao.CompanyTenantRelOperationCustomizedDao;
import com.xforceplus.entity.CompanyTenantRelOperation;
import com.xforceplus.query.CompanyTenantRelOperationQueryHelper;
import io.geewit.data.jpa.essential.utils.TupleQueryUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.List;


@SuppressWarnings({"all"})
public class CompanyTenantRelOperationCustomizedDaoImpl implements CompanyTenantRelOperationCustomizedDao {

    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<Tuple> findTuples(Request.Query query, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Tuple> tupleCriteriaQuery = criteriaBuilder.createTupleQuery();
        Root<CompanyTenantRelOperation> tupleRoot = tupleCriteriaQuery.from(CompanyTenantRelOperation.class);
        Predicate predicate = CompanyTenantRelOperationQueryHelper.queryTuplePredicate(query, tupleRoot, tupleCriteriaQuery, criteriaBuilder);
        Sort sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        if (sort.isSorted()) {
            List<Order> orders = new ArrayList<>();
            if (!CollectionUtils.isEmpty(tupleCriteriaQuery.getOrderList())) {
                orders.addAll(tupleCriteriaQuery.getOrderList());
            }
            List<Order> toOrders = QueryUtils.toOrders(sort, tupleRoot, criteriaBuilder);
            if (!CollectionUtils.isEmpty(toOrders)) {
                orders.addAll(toOrders);
            }
            if (!CollectionUtils.isEmpty(orders)) {
                tupleCriteriaQuery.orderBy(orders);
            }
        }
        TypedQuery<Tuple> tupleQuery = entityManager.createQuery(tupleCriteriaQuery);
        if (pageable.isPaged()) {
            tupleQuery.setFirstResult((int) pageable.getOffset());
            tupleQuery.setMaxResults(pageable.getPageSize());
        }
        List<Tuple> results = tupleQuery.getResultList();
        if (pageable.isPaged()) {
            CriteriaBuilder countCriteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery<Long> countCriteriaQuery = countCriteriaBuilder.createQuery(Long.class);
            Root<CompanyTenantRelOperation> countRoot = countCriteriaQuery.from(CompanyTenantRelOperation.class);
            CompanyTenantRelOperationQueryHelper.queryCountPredicate(query, countRoot, countCriteriaQuery, countCriteriaBuilder);
            return PageableExecutionUtils.getPage(results, pageable,
                    () -> TupleQueryUtils.executeCountQuery(TupleQueryUtils.getCountQuery(entityManager, countRoot, countCriteriaQuery, countCriteriaBuilder)));
        } else {
            return new PageImpl<>(results);
        }
    }

    @Override
    public Tuple findTuple(Request.Query query) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Tuple> tupleCriteriaQuery = criteriaBuilder.createTupleQuery();
        Root<CompanyTenantRelOperation> tupleRoot = tupleCriteriaQuery.from(CompanyTenantRelOperation.class);
        Predicate predicate = CompanyTenantRelOperationQueryHelper.queryTuplePredicate(query, tupleRoot, tupleCriteriaQuery, criteriaBuilder);
        TypedQuery<Tuple> tupleQuery = entityManager.createQuery(tupleCriteriaQuery);
        Tuple result = tupleQuery.getSingleResult();
        return result;
    }
}
