package com.xforceplus.dao.impl;

import com.xforceplus.api.model.OrgModel.*;
import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.bo.org.OrgUserStatisticsQueryBo;
import com.xforceplus.dao.OrgStructCustomizedDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.dto.org.OrgCompanyNoDTO;
import com.xforceplus.dto.org.OrgParentDTO;
import com.xforceplus.dto.org.OrgUserStatisticsDTO;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.query.OrgQueryHelper;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.utils.enums.EnumUtils;
import io.geewit.data.jpa.essential.utils.TupleQueryUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.persistence.*;
import javax.persistence.criteria.*;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;


@SuppressWarnings({"all"})
@Slf4j
public class OrgStructCustomizedDaoImpl extends AbstractDefaultJpaRepositoryImpl implements OrgStructCustomizedDao {

    /**
     * 获取组织子孙列表
     * @param orgId
     * @return
     */
    @Override
    public List<OrgStruct> findDescendantsById(long orgId) {
        TypedQuery subQuery = entityManager.createQuery("select o.parentIds from OrgStruct o where o.orgId = :orgId", String.class);
        subQuery.setParameter("orgId", orgId);
        subQuery.setFirstResult(0).setMaxResults(1);
        String parentIds = (String) subQuery.getSingleResult();
        if (StringUtils.isBlank(parentIds)) {
            throw new IllegalArgumentException("未找到实体");
        }
        TypedQuery query = entityManager.createQuery("select o from OrgStruct o where o.parentIds like :parentIds order by o.parentIds", OrgStruct.class);
        query.setParameter("parentIds", parentIds + "%");
        return query.getResultList();
    }

    @Override
    public Page<Tuple> findTuples(Request.Query query, Pageable pageable) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        Sort sort = pageable.isPaged() ? pageable.getSort() : Sort.unsorted();
        TypedQuery<Tuple> listQuery = this.tupleQuery(query, sort);
        if (pageable.isPaged()) {
            listQuery.setFirstResult((int) pageable.getOffset());
            listQuery.setMaxResults(pageable.getPageSize());
        }
        List<Tuple> results = listQuery.getResultList();
        CriteriaBuilder countCriteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Long> countCriteriaQuery = countCriteriaBuilder.createQuery(Long.class);
        Root<OrgStruct> countRoot = countCriteriaQuery.from(OrgStruct.class);
        OrgQueryHelper.queryCountPredicate(query, countRoot, countCriteriaQuery, countCriteriaBuilder);
        if (pageable.isPaged()) {
            return PageableExecutionUtils.getPage(results, pageable,
                    () -> TupleQueryUtils.executeCountQuery(TupleQueryUtils.getCountQuery(entityManager, countRoot, countCriteriaQuery, countCriteriaBuilder)));
        } else {
            return new PageImpl<>(results);
        }
    }

    @Override
    public List<Tuple> findTuples(Request.Query query, Sort sort) {
        TypedQuery<Tuple> listQuery = this.tupleQuery(query, sort);
        List<Tuple> results = listQuery.getResultList();
        return results;
    }

    @Override
    public List<OrgStruct> findRelatedCompaniesByUserId(long userId) {
        StringBuilder selectBuilder = new StringBuilder("SELECT" +
                " ro.org_struct_id AS orgId," +
                " ro.tenant_id AS tenantId," +
                " ro.company_id AS companyId," +
                " ro.org_code AS orgCode," +
                " ro.org_name AS orgName," +
                " ro.parent_ids AS parentIds," +
                " ro.parent_id AS parentId," +
                " ro.org_type AS orgType," +
                " ro.org_desc AS orgDesc," +
                " ro.`status` AS `orgStatus`," +
                " ro.audit_status AS auditStatus," +
                " ro.enabled_time AS enabledTime," +
                " ro.disabled_time AS disabledTime," +
                " ro.create_user_id AS orgCreaterId," +
                " ro.create_user_name AS orgCreaterName," +
                " ro.create_time AS orgCreateTime," +
                " ro.update_user_id AS orgUpdaterId," +
                " ro.update_user_name AS orgUpdaterName," +
                " ro.update_time AS orgUpdateTime," +
                " ctr.switches as relatedSwitches," +
                " c.company_code AS companyCode," +
                " c.company_name AS companyName," +
                " c.tax_num AS taxNum," +
                " c.location_area AS locationArea," +
                " c.location_city AS locationCity," +
                " c.location_addr AS locationAddr," +
                " c.company_phone AS companyPhone," +
                " c.business_start_time AS businessStartTime," +
                " c.business_end_time AS businessEndTime," +
                " c.business_time_long AS businessTimeLong," +
                " c.business_scope AS businessScope," +
                " c.company_logo AS companyLogo," +
                " c.business_license AS businessLicense," +
                " c.plat_manager_status AS platManagerStatus," +
                " c.manager_location AS managerLocation," +
                " c.manager_card_type AS managerCardType," +
                " c.manager_name AS managerName," +
                " c.manager_id_card AS managerIdCard," +
                " c.manager_phone AS managerPhone," +
                " c.manager_id_card_start_time AS managerIdCardStartTime," +
                " c.manager_id_card_end_time AS managerIdCardEndTime," +
                " c.manager_id_card_time_long AS managerIdCardTimeLong," +
                " c.manager_id_card_front_photo AS managerIdCardFrontPhoto," +
                " c.manager_id_card_back_photo AS managerIdCardBackPhoto," +
                " c.bank_name AS bankName," +
                " c.bank_branch_name AS bankBranchName," +
                " c.bank_no AS bankNo," +
                " c.bank_area AS bankArea," +
                " c.bank_city AS bankCity," +
                " c.operate_reason AS companyOperateReason," +
                " c.tradition_authen_flag AS traditionAuthenFlag," +
                " c.inspection_service_flag AS inspectionServiceFlag," +
                " c.speed_inspection_channel_flag AS speedInspectionChannelFlag," +
                " c.`status` AS companyStatus," +
                " c.cquota AS cquota," +
                " c.squota AS squota," +
                " c.ce_quota AS ceQuota," +
                " c.ju_quota AS juQuota," +
                " c.regist_location_area AS registLocationArea," +
                " c.regist_location_city AS registLocationCity," +
                " c.regist_location_addr AS registLocationAddr," +
                " c.taxpayer_qualification_type AS taxpayerQualificationType," +
                " c.taxpayer_qualification AS taxpayerQualification," +
                " c.identification_type AS identificationType," +
                " c.proxy_manager_name AS proxyManagerName," +
                " c.proxy_manager_card_type AS proxyManagerCardType," +
                " c.proxy_manager_id_card AS proxyManagerIdCard," +
                " c.host_tenant_id AS hostTenantId," +
                " c.vehicle_limit AS vehicleLimit," +
                " c.is_effective AS isEffective," +
                " c.effective_date AS effectiveDate," +
                " c.se_quota AS seQuota," +
                " c.proxy_manager_id_card_back_photo AS proxyManagerIdCardBackPhoto," +
                " c.proxy_manager_id_card_front_photo AS proxyManagerIdCardFrontPhoto," +
                " c.proxy_manager_id_card_time_long AS proxyManagerIdCardTimeLong," +
                " c.proxy_manager_id_card_end_time AS proxyManagerIdCardEndTime," +
                " c.proxy_manager_id_card_start_time AS proxyManagerIdCardStartTime," +
                " c.proxy_manager_phone AS proxyManagerPhone," +
                " c.create_user_id AS companyCreaterId," +
                " c.create_user_name AS companyCreaterName," +
                " c.create_time AS companyCreateTime," +
                " c.update_user_id AS companyUpdaterId," +
                " c.update_user_name AS companyUpdaterName," +
                " c.update_time AS companyUpdateTime," +
                " te.tenant_name AS tenantName," +
                " te.tenant_code AS tenantCode," +
                " te.tenant_desc AS tenantDesc," +
                " te.operate_reason AS tenantOperateReason," +
                " te.settled_origin AS settledOrigin," +
                " te.`status` AS tenantStatus," +
                " te.tenant_logo AS tenantLogo ," +
                " te.create_user_id AS tenantCreaterId," +
                " te.create_user_name AS tenantCreaterName," +
                " te.create_time AS tenantCreateTime," +
                " te.update_user_id AS tenantUpdaterId," +
                " te.update_user_name AS tenantUpdaterName," +
                " te.update_time AS tenantUpdateTime" +
                " FROM" +
                " company_tenant_rel AS ctr " +
                " LEFT JOIN sys_org_struct AS ro ON ctr.company_id = ro.company_id" +
                " AND ctr.tenant_id = ro.tenant_id " +
                " LEFT JOIN bss_company AS c ON ro.company_id = c.company_id" +
                " LEFT JOIN bss_tenant AS te ON ro.tenant_id = te.tenant_id" +
                " LEFT JOIN (" +
                " SELECT" +
                " ho.company_id AS company_id," +
                " ho.tenant_id AS tenant_id" +
                " FROM" +
                " sys_org_user_rel AS our" +
                " LEFT JOIN sys_org_struct AS ho ON ho.org_struct_id = our.org_struct_id" +
                " WHERE" +
                " our.user_id = :userId" +
                ") AS t ON t.company_id = ro.company_id" +
                " WHERE" +
                " t.tenant_id is not null and t.tenant_id = ctr.related_tenant_id" +
                " and ro.status = 1" +
                " and c.status = 1");
        Query selectQuery = this.entityManager.createNativeQuery(selectBuilder.toString());
        selectQuery.setParameter("userId", userId);
        selectQuery.unwrap(NativeQuery.class)
                .setResultTransformer(new ResultTransformer() {

                    @Override
                    public Object transformTuple(Object[] tuples, String[] aliases) {
                        Long orgId = tuples[0] != null ? ((Number)tuples[0]).longValue() : null;
                        Long tenantId = tuples[1] != null ? ((Number)tuples[1]).longValue() : null;
                        Long companyId = tuples[2] != null ? ((Number)tuples[2]).longValue() : null;
                        OrgType orgType = tuples[7] != null ? EnumUtils.forToken(OrgType.class, ((Number)tuples[7]).intValue()) : null;
                        //region Construction of OrgStruct
                        OrgStruct org = new OrgStruct();
                        org.setOrgId(orgId);
                        org.setTenantId(tenantId);
                        org.setCompanyId(companyId);
                        org.setOrgCode((String)tuples[3]);
                        org.setOrgName((String)tuples[4]);
                        org.setParentIds((String)tuples[5]);
                        org.setParentId(tuples[6] != null ? ((Number)tuples[6]).longValue() : null);
                        org.setOrgType(orgType);
                        org.setOrgDesc((String)tuples[8]);
                        org.setStatus(tuples[9] != null ? ((Number)tuples[9]).intValue() : null);
                        org.setAuditStatus(tuples[10] != null ? ((Number)tuples[10]).intValue() : null);
                        org.setEnabledTime((Date)tuples[11]);
                        org.setDisabledTime((Date)tuples[12]);
                        org.setCreaterId((String)tuples[13]);
                        org.setCreaterName((String)tuples[14]);
                        org.setCreateTime((Date)tuples[15]);
                        org.setUpdaterId((String)tuples[16]);
                        org.setUpdaterName((String)tuples[17]);
                        org.setUpdateTime((Date)tuples[18]);
                        org.setRelatedSwitches(tuples[19] != null ? ((Number)tuples[19]).intValue() : null);
                        //endregion

                        //region Construction of Company
                        Company company = new Company();
                        company.setCompanyId(companyId);
                        company.setCompanyCode((String)tuples[20]);
                        company.setCompanyName((String)tuples[21]);
                        company.setTaxNum((String)tuples[22]);
                        company.setLocationArea((String)tuples[23]);
                        company.setLocationCity((String)tuples[24]);
                        company.setLocationAddr((String)tuples[25]);
                        company.setCompanyPhone((String)tuples[26]);
                        company.setBusinessStartTime((Date)tuples[27]);
                        company.setBusinessEndTime((Date)tuples[28]);
                        company.setBusinessTimeLong(tuples[29] != null ? ((Number)tuples[29]).intValue() : null);
                        company.setBusinessScope((String)tuples[30]);
                        company.setCompanyLogo((String)tuples[31]);
                        company.setBusinessLicense((String)tuples[32]);
                        company.setPlatManagerStatus(tuples[33] != null ? ((Number)tuples[33]).intValue() : null);
                        company.setManagerLocation((String)tuples[34]);
                        company.setManagerCardType((String)tuples[35]);
                        company.setManagerName((String)tuples[36]);
                        company.setManagerIdCard((String)tuples[37]);
                        company.setManagerPhone((String)tuples[38]);
                        company.setManagerIdCardStartTime((Date)tuples[39]);
                        company.setManagerIdCardEndTime((Date)tuples[40]);
                        company.setManagerIdCardTimeLong(tuples[41] != null ? ((Number)tuples[41]).intValue() : null);
                        company.setManagerIdCardFrontPhoto((String)tuples[42]);
                        company.setManagerIdCardBackPhoto((String)tuples[43]);
                        company.setBankName((String)tuples[44]);
                        company.setBankBranchName((String)tuples[45]);
                        company.setBankNo((String)tuples[46]);
                        company.setBankArea((String)tuples[47]);
                        company.setBankCity((String)tuples[48]);
                        company.setOperateReason((String)tuples[49]);
                        company.setTraditionAuthenFlag(tuples[50] != null ? ((Number)tuples[50]).intValue() : null);
                        company.setInspectionServiceFlag(tuples[51] != null ? ((Number)tuples[51]).intValue() : null);
                        company.setSpeedInspectionChannelFlag(tuples[52] != null ? ((Number)tuples[52]).intValue() : null);
                        company.setStatus(tuples[53] != null ? ((Number)tuples[53]).intValue() : null);
                        company.setCquota(tuples[54] != null ? BigDecimal.valueOf(((Number)tuples[54]).doubleValue()) : null);
                        company.setSquota(tuples[55] != null ? BigDecimal.valueOf(((Number)tuples[55]).doubleValue()) : null);
                        company.setCeQuota(tuples[56] != null ? BigDecimal.valueOf(((Number)tuples[56]).doubleValue()) : null);
                        company.setJuQuota(tuples[57] != null ? BigDecimal.valueOf(((Number)tuples[57]).doubleValue()) : null);
                        company.setRegistLocationArea((String)tuples[58]);
                        company.setRegistLocationCity((String)tuples[59]);
                        company.setRegistLocationAddr((String)tuples[60]);
                        company.setTaxpayerQualificationType(tuples[61] != null ? ((Number)tuples[61]).intValue() : null);
                        company.setTaxpayerQualification((String)tuples[62]);
                        company.setIdentificationType((String)tuples[63]);
                        company.setProxyManagerName((String)tuples[64]);
                        company.setProxyManagerCardType((String)tuples[65]);
                        company.setProxyManagerIdCard((String)tuples[66]);
                        company.setHostTenantId(tuples[67] != null ? ((Number)tuples[67]).longValue() : null);
                        company.setVehicleLimit(tuples[68] != null ? BigDecimal.valueOf(((Number)tuples[68]).doubleValue()) : null);
                        company.setEffective(tuples[69] != null ? Byte.valueOf("1").equals((Byte)tuples[69]) : null);
                        company.setEffectiveDate((Date)tuples[70]);
                        company.setSeQuota(tuples[71] != null ? BigDecimal.valueOf(((Number)tuples[71]).doubleValue()) : null);
                        company.setProxyManagerIdCardBackPhoto((String)tuples[72]);
                        company.setProxyManagerIdCardFrontPhoto((String)tuples[73]);
                        company.setProxyManagerIdCardTimeLong(tuples[74] != null ? ((Number)tuples[74]).intValue() : null);
                        company.setProxyManagerIdCardEndTime((Date)tuples[75]);
                        company.setProxyManagerIdCardStartTime((Date)tuples[76]);
                        company.setProxyManagerPhone((String)tuples[77]);
                        company.setCreaterId((String)tuples[78]);
                        company.setCreaterName((String)tuples[79]);
                        company.setCreateTime((Date)tuples[80]);
                        company.setUpdaterId((String)tuples[81]);
                        company.setUpdaterName((String)tuples[82]);
                        company.setUpdateTime((Date)tuples[83]);
                        org.setCompany(company);
                        //endregion

                        //region Construction of Tenant
                        Tenant tenant = new Tenant();
                        tenant.setTenantId(tenantId);
                        tenant.setTenantName((String)tuples[84]);
                        tenant.setTenantCode((String)tuples[85]);
                        tenant.setTenantDesc((String)tuples[86]);
                        tenant.setOperateReason((String)tuples[87]);
                        tenant.setSettledOrigin((String)tuples[88]);
                        tenant.setStatus(tuples[89] != null ? ((Number)tuples[89]).intValue() : null);
                        tenant.setTenantLogo((String)tuples[90]);
                        tenant.setCreaterId((String)tuples[91]);
                        tenant.setCreaterName((String)tuples[92]);
                        tenant.setCreateTime((Date)tuples[93]);
                        tenant.setUpdaterId((String)tuples[94]);
                        tenant.setUpdaterName((String)tuples[95]);
                        tenant.setUpdateTime((Date)tuples[96]);
                        org.setTenant(tenant);
                        //endregion

                        return org;
                    }

                    @Override
                    public List transformList(List collection) {
                        return collection;
                    }
                });
        return selectQuery.getResultList();
    }

    private TypedQuery<Tuple> tupleQuery(Request.Query query, Sort sort) {
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Tuple> tupleCriteriaQuery = criteriaBuilder.createTupleQuery();
        Root<OrgStruct> tupleRoot = tupleCriteriaQuery.from(OrgStruct.class);
        Predicate predicate = OrgQueryHelper.queryTuplePredicate(query, tupleRoot, tupleCriteriaQuery, criteriaBuilder);
        if (sort.isSorted()) {
            List<Order> orders = new ArrayList<>();
            if (!CollectionUtils.isEmpty(tupleCriteriaQuery.getOrderList())) {
                orders.addAll(tupleCriteriaQuery.getOrderList());
            }
            List<Order> toOrders = QueryUtils.toOrders(sort, tupleRoot, criteriaBuilder);
            if (!CollectionUtils.isEmpty(toOrders)) {
                orders.addAll(toOrders);
            }
            if (!CollectionUtils.isEmpty(orders)) {
                tupleCriteriaQuery.orderBy(orders);
            }
        }
        TypedQuery<Tuple> listQuery = entityManager.createQuery(tupleCriteriaQuery);
        return listQuery;
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgDto> getOrgByTenantCodeAndOrgCode(String tenantCode, String orgCode) {
        StringQuery query =
                StringQuery.builder()
                        .query("select sos.org_struct_id as org_id from bss_tenant bt \n"
                                + "inner join sys_org_struct sos on sos.tenant_id = bt.tenant_id \n"
                                + " where 1=1 and sos.status = 1 ")
                        .predicateNotNull(tenantCode)
                        .query(" and bt.tenant_code = :tenantCode ")
                        .param("tenantCode", tenantCode)
                        .predicateNotNull(orgCode)
                        .query(" and sos.org_code = :orgCode ")
                        .param("orgCode", orgCode)
                        .build();
        return this.findBySql(query, OrgDto.class, Boolean.TRUE);
    }


    /**
     * 根据税号查询
     *
     * @param queryBo 查询参数
     * @return List<OrgCompanyDTO>
     */
    @Override
    public List<OrgCompanyDTO> findOrgCompanyByTaxNum(OrgCompanyQueryBo queryBo) {
        Assert.hasText(queryBo.getTaxNum(), "公司税号不能为空");
        StringQuery stringQuery = StringQuery.builder().query("select sos.tenant_id, sos.company_id, bc.company_code, bc.company_name, bc.tax_num, sos.org_struct_id as org_id, sos.org_name," +
                " sos.org_code from sys_org_struct sos,bss_company bc, bss_tenant tenant" +
                " where sos.company_id = bc.company_id and bc.tax_num=:taxNum and sos.tenant_id = tenant.tenant_id")
                .param("taxNum", queryBo.getTaxNum())
                .predicateNotNull(queryBo.getCompanyId())
                .query(" and bc.company_id = :companyId ")
                .param("companyId", queryBo.getCompanyId())

                .predicateNotNull(queryBo.getOrgId())
                .query(" and sos.org_struct_id = :orgId ")
                .param("orgId", queryBo.getOrgId())

                .predicateNotNull(queryBo.getTenantCode())
                .query(" and tenant.tenant_code = :tenantCode ")
                .param("tenantCode", queryBo.getTenantCode())

                .predicateNotNull(queryBo.getTenantId())
                .query(" and sos.tenant_id = :tenantId ")
                .param("tenantId", queryBo.getTenantId())
                .predicate(true)
                .query(" order by sos.org_struct_id desc")
                .build();
        return this.findBySql(stringQuery, OrgCompanyDTO.class, Boolean.TRUE);
    }

    /**
     * 根据组织IDs查询
     *
     * @param orgIds 组织IDs
     * @return List<OrgCompanyNoDTO>
     */
    @Override
    public List<OrgCompanyNoDTO> findCompanyNoByOrgIds(Collection<Long> orgIds) {
        StringQuery stringQuery = StringQuery.builder()
                .query("select org_struct_id as org_id, company_no from sys_org_companyno soc where")
                .query(" soc.org_struct_id in :orgIds")
                .predicate(true).param("orgIds", orgIds)
                .build();
        return this.findBySql(stringQuery, OrgCompanyNoDTO.class, Boolean.TRUE);
    }

    /**
     * 查询每个组织组织用户数据统计
     *
     * @param queryBo 查询对象
     * @return List<OrgUserStatisticsDTO>
     */
    @Override
    public List<OrgUserStatisticsDTO> findUserStatisticsByOrgIds(OrgUserStatisticsQueryBo queryBo) {
        Assert.notEmpty(queryBo.getOrgIds(), "组织ID列表不能为空");
        log.info("OrgUserStatisticsQueryBo:{}", queryBo.toString());
        StringQuery stringQuery = StringQuery.builder()
                .query(" select ur.org_struct_id as org_id, count(*) as user_total_num")
                .query(" from sys_org_user_rel ur where org_struct_id in :orgIds")
                .predicate(true)
                .inParam("orgIds", queryBo.getOrgIds())
                .predicate(true)
                .query(" group by ur.org_struct_id")
                .build();
        return super.findBySql(stringQuery, OrgUserStatisticsDTO.class, Boolean.TRUE);
    }


    /**
     * 查询父组组织信息
     *
     * @param orgIds 组织ID列表
     * @return List<OrgParentDTO> 父组组织信息
     */
    @Override
    public List<OrgParentDTO> findOrgParentByOrgIds(Collection<Long> orgIds) {
        Assert.notEmpty(orgIds, "组织ID列表不能为空");
        StringQuery stringQuery = StringQuery
                .builder()
                .query("select org_struct_id as org_id, org_name from sys_org_struct where org_struct_id in :orgIds")
                .inParam("orgIds", orgIds)
                .build();
        return super.findBySql(stringQuery, OrgParentDTO.class, Boolean.TRUE);
    }
}
