package com.xforceplus.dao.impl;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.dao.RoleCustomizedDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.tenant.RoleExportDto;
import com.xforceplus.domain.tenant.RoleRelAccountExportDto;
import com.xforceplus.domain.tenant.RoleResourceDTO;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.persistence.Query;
import java.util.List;

/**
 * 角色扩展查询
 *
 * @author geewit
 * @author Evan
 */
@SuppressWarnings({"all"})
public class RoleCustomizedDaoImpl extends AbstractDefaultJpaRepositoryImpl implements RoleCustomizedDao {
    private final static Logger logger = LoggerFactory.getLogger(RoleCustomizedDaoImpl.class);

    @Override
    public List<RoleExportDto> findRolesResourcesetRel(Long tenantId, RoleModel.Request.Export query, Pageable pageable) {

        StringBuilder selectBuilder = new StringBuilder("SELECT DISTINCT" +
                " a.role_id as roleId" +
                ",IF(a.role_name IS NULL,'',a.role_name)  as roleName" +
                ",IF(a.role_code IS NULL,'',a.role_code)  as roleCode" +
                ",c.resourceset_id as resourcesetId" +
                ",IF(c.resourceset_name IS NULL,'',c.resourceset_name)  as resourcesetName" +
                ",IF(c.resourceset_code IS NULL,'',c.resourceset_code)  as resourcesetCode" +
                ",e.resource_id as resourceId" +
                ",IF(e.resource_name IS NULL,'',e.resource_name)  as resourceName" +
                ",IF(e.resource_code IS NULL,'',e.resource_code)  as resourceCode" +
                ",g.service_package_id as servicePackageId" +
                ",IF(g.service_package_name IS NULL,'',g.service_package_name)  as servicePackageName" +
                ",IF(g.service_package_code IS NULL,'',g.service_package_code)  as servicePackageCode" +
                " FROM" +
                " sys_role a" +
                " LEFT JOIN sys_role_resourceset_rel b ON a.role_id = b.role_id" +
                " LEFT JOIN sys_resourceset c ON c.resourceset_id = b.resouseset_id" +
                " LEFT JOIN sys_resourceset_resource_rel d ON c.resourceset_id = d.resourceset_id" +
                " LEFT JOIN sys_resource e ON e.resource_id = d.resource_id" +
                " LEFT JOIN bss_service_resourceset_rel f ON c.resourceset_id = f.resourceset_id" +
                " LEFT JOIN bss_service_package g ON g.service_package_id = f.service_package_id" +
                " LEFT JOIN bss_company_service_rel h ON h.service_package_id = f.service_package_id" +
                " WHERE 1=1");

        StringBuilder queryBuilder = new StringBuilder();

        queryBuilder.append(" and h.tenant_id = :tenantId").append(" and a.tenant_id = :tenantId");

        if (query != null) {
            if (!CollectionUtils.isEmpty(query.getIds())) {
                queryBuilder.append(" and a.role_id in (:ids)");
            } else {
                if (StringUtils.isNotBlank(query.getRoleCode())) {
                    queryBuilder.append(" and a.role_code = :roleCode");
                } else if (StringUtils.isNotBlank(query.getSearchKey())) {
                    queryBuilder.append(" and a.role_code like :searchKey");
                }
                if (StringUtils.isNotBlank(query.getRoleName())) {
                    queryBuilder.append(" and a.role_name = :roleName");
                } else if (StringUtils.isNotBlank(query.getSearchKey())) {
                    queryBuilder.append(" and a.role_name like :searchKey");
                }
                if (null != query.getStatus()) {
                    queryBuilder.append(" and a.status = :status");
                }
            }

        }
        selectBuilder.append(queryBuilder);
        String selectHql = selectBuilder.toString();

        logger.info("selectHQL = {}", selectHql);
        Query selectQuery = entityManager.createNativeQuery(selectHql);

        selectQuery.setParameter("tenantId", tenantId);
        if (query != null) {
            if (!CollectionUtils.isEmpty(query.getIds())) {
                selectQuery.setParameter("ids", query.getIds());
            } else {
                if (StringUtils.isNotBlank(query.getRoleName()) || StringUtils.isNotBlank(query.getRoleCode())) {
                    if (StringUtils.isNotBlank(query.getRoleName())) {
                        selectQuery.setParameter("roleName", query.getRoleName());
                    }
                    if (StringUtils.isNotBlank(query.getRoleCode())) {
                        selectQuery.setParameter("roleCode", query.getRoleCode());
                    }
                } else if (StringUtils.isNotBlank(query.getSearchKey())) {
                    selectQuery.setParameter("searchKey", query.getSearchKey() + "%");
                }

                if (null != query.getStatus()) {
                    selectQuery.setParameter("status", query.getStatus());
                }
            }

        }

        selectQuery.unwrap(NativeQuery.class)
                .addScalar("roleId", StandardBasicTypes.LONG)
                .addScalar("roleName", StandardBasicTypes.STRING)
                .addScalar("roleCode", StandardBasicTypes.STRING)
                .addScalar("resourceId", StandardBasicTypes.LONG)
                .addScalar("resourceName", StandardBasicTypes.STRING)
                .addScalar("resourceCode", StandardBasicTypes.STRING)
                .addScalar("resourcesetId", StandardBasicTypes.LONG)
                .addScalar("resourcesetName", StandardBasicTypes.STRING)
                .addScalar("resourcesetCode", StandardBasicTypes.STRING)
                .addScalar("servicePackageId", StandardBasicTypes.LONG)
                .addScalar("servicePackageName", StandardBasicTypes.STRING)
                .addScalar("servicePackageCode", StandardBasicTypes.STRING)
                .setResultTransformer(Transformers.aliasToBean(RoleExportDto.class));
        return selectQuery.getResultList();
    }

    @Override
    public List<RoleRelAccountExportDto> findRolesRelAccount(Long tenantId, RoleModel.Request.Export query, Pageable pageable) {

        StringBuilder selectBuilder = new StringBuilder("SELECT" +
                " a.role_id as roleId" +
                ",IF(a.role_name IS NULL,'',a.role_name) as roleName" +
                ",IF(a.role_code IS NULL,'',a.role_code) as roleCode" +
                ",IF(d.email IS NULL,'',d.email) as email" +
                ",IF(d.tel_phone IS NULL,'',d.tel_phone) as telPhone" +
                ",IF(d.username IS NULL,'',d.username) as username" +
                ",IF(c.user_name IS NULL,'',c.user_name) as realName" +
                " FROM" +
                " sys_role a" +
                " LEFT JOIN sys_role_user_rel b ON a.role_id = b.role_id" +
                " LEFT JOIN sys_user c ON c.user_id = b.user_id" +
                " LEFT JOIN sys_sass_account d ON c.account_id = d.account_id" +
                " WHERE 1=1");

        StringBuilder queryBuilder = new StringBuilder();

        queryBuilder.append(" and a.tenant_id = :tenantId").append(" and c.tenant_id = :tenantId");

        if (query != null) {
            if (!CollectionUtils.isEmpty(query.getIds())) {
                queryBuilder.append(" and a.role_id in (:ids)");
            } else {
                if (StringUtils.isNotBlank(query.getRoleCode())) {
                    queryBuilder.append(" and a.role_code = :roleCode");
                } else if (StringUtils.isNotBlank(query.getSearchKey())) {
                    queryBuilder.append(" and a.role_code like :searchKey");
                }
                if (StringUtils.isNotBlank(query.getRoleName())) {
                    queryBuilder.append(" and a.role_name = :roleName");
                } else if (StringUtils.isNotBlank(query.getSearchKey())) {
                    queryBuilder.append(" and a.role_name like :searchKey");
                }
                if (null != query.getStatus()) {
                    queryBuilder.append(" and a.status = :status");
                }
            }

        }
        selectBuilder.append(queryBuilder);
        String selectHql = selectBuilder.toString();

        logger.info("selectHQL = {}", selectHql);
        Query selectQuery = entityManager.createNativeQuery(selectHql);

        selectQuery.setParameter("tenantId", tenantId);
        if (query != null) {
            if (!CollectionUtils.isEmpty(query.getIds())) {
                selectQuery.setParameter("ids", query.getIds());
            } else {
                if (StringUtils.isNotBlank(query.getRoleName()) || StringUtils.isNotBlank(query.getRoleCode())) {
                    if (StringUtils.isNotBlank(query.getRoleName())) {
                        selectQuery.setParameter("roleName", query.getRoleName());
                    }
                    if (StringUtils.isNotBlank(query.getRoleCode())) {
                        selectQuery.setParameter("roleCode", query.getRoleCode());
                    }
                } else if (StringUtils.isNotBlank(query.getSearchKey())) {
                    selectQuery.setParameter("searchKey", query.getSearchKey() + "%");
                }
                if (null != query.getStatus()) {
                    selectQuery.setParameter("status", query.getStatus());
                }
            }

        }

        selectQuery.unwrap(NativeQuery.class)
                .addScalar("roleId", StandardBasicTypes.LONG)
                .addScalar("roleName", StandardBasicTypes.STRING)
                .addScalar("roleCode", StandardBasicTypes.STRING)
                .addScalar("email", StandardBasicTypes.STRING)
                .addScalar("telPhone", StandardBasicTypes.STRING)
                .addScalar("username", StandardBasicTypes.STRING)
                .addScalar("realName", StandardBasicTypes.STRING)
                .setResultTransformer(Transformers.aliasToBean(RoleRelAccountExportDto.class));
        return selectQuery.getResultList();
    }

    /**
     * 按角色ID查询角色关系功能集 (返回数据有重复的功能集)
     *
     * @param roleId 角色ID
     * @param status 状态
     * @return List<RoleResourceDTO>
     */
    @Override
    public List<RoleResourceDTO> findResourceSetByRoleId(Long roleId, Integer status) {
        Assert.notNull(roleId, "角色Id不为空");
        Assert.notNull(status, "状态不为空");
        StringQuery query = StringQuery.builder()
                .query(" select  srs.resourceset_id   resource_set_id,srs.resourceset_code   `itemCode`,srs.resourceset_name  `itemName`, srs.`status`,srs.role_id  " +
                        "  from sys_resourceset srs INNER JOIN " +
                        " sys_role_resourceset_rel srrr on   srs.resourceset_id=srrr.resouseset_id " +
                        " where  srrr.role_id=:roleId and srs.`status`=:status ")
                .predicate(true)
                .param("roleId", roleId)
                .param("status", status)
                .build();
        return this.findBySql(query, RoleResourceDTO.class, Boolean.TRUE);
    }
}
