/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ResourceExtendDaoImpl.java   2020-10-20 11-26-43
 * Author: Evan
 */
package com.xforceplus.dao.impl;

import com.xforceplus.dao.ServiceApiExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.dto.resource.ServiceApiResourceCodeVo;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-20 11-26-43
 * @since V1.0
 */
@Repository
public class ServiceApiExtendDaoImpl extends AbstractDefaultJpaRepositoryImpl implements
        ServiceApiExtendDao {

    private static final String QUERY_SERVICE_API;

    static {
        QUERY_SERVICE_API = " select t1.service_api_id,  t1.service_api_url, t1.request_method, "
                + " t1.app_id, t1.route_id, t2.resource_id "
                + " from sys_service_api t1 "
                + " inner join sys_resource_api_rel t2 on  t1.service_api_id = t2.service_api_id ";
    }


    @Override
    @Transactional(readOnly = true)
    public List<ServiceApiResourceCodeVo> getExactServiceApiResourceList() {
        //不能用分页，需要一次查询所有的，理论上一个公司在一个app下不会有太多资源码
        StringQuery query = StringQuery.builder()
                .query(QUERY_SERVICE_API
//            + " where  t1.service_api_url not like '%{%' and t1.status = 1 "
                        + " where 1=1 ")
                .query("  and t1.service_api_url not like :percent_param")
                .likeParam("percent_param", "{")
                .query(" and t1.status=:status ")
                .param("status", 1)
                .build();
        //使用下划线转换器
        return super.findBySql(query, ServiceApiResourceCodeVo.class, true);
    }


    @Override
    @Transactional(readOnly = true)
    public List<ServiceApiResourceCodeVo> getPathVariableServiceApiResourceList() {
        //不能用分页，需要一次查询所有的，理论上一个公司在一个app下不会有太多资源码
        StringQuery query = StringQuery.builder()
                .query(QUERY_SERVICE_API
//            + " where  t1.service_api_url like '%{%' and t1.status = 1 "
                        + " where 1=1 ")

                .query("  and t1.service_api_url like :percent_param")
                .likeParam("percent_param", "{")
                .query(" and t1.status=:status ")
                .param("status", 1)
                .build();
        //使用下划线转换器
        return super.findBySql(query, ServiceApiResourceCodeVo.class, true);
    }
}
